/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.astralsorcery;

import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.item.ItemColoredLens;
import hellfirepvp.astralsorcery.common.item.block.ItemCollectorCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.tile.TileAttunementRelay;
import hellfirepvp.astralsorcery.common.tile.TileGrindstone;
import hellfirepvp.astralsorcery.common.tile.TileIlluminator;
import hellfirepvp.astralsorcery.common.tile.TileMapDrawingTable;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.tile.TileWell;
import hellfirepvp.astralsorcery.common.tile.network.TileCollectorCrystal;
import hellfirepvp.astralsorcery.common.tile.network.TileCrystalLens;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BaseMetaProvider;
import org.squiddev.plethora.api.meta.BasicMetaProvider;
import org.squiddev.plethora.api.meta.IMetaProvider;
import org.squiddev.plethora.api.meta.ItemStackContextMetaProvider;
import org.squiddev.plethora.api.method.ContextHelpers;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.method.TypedLuaObject;
import org.squiddev.plethora.integration.MetaWrapper;

@Injects(value="astralsorcery")
public final class MetaBlocks {
    public static final IMetaProvider<TileWell> META_LIGHT_WELL = new BaseMetaProvider<TileWell>("Provides the catalyst item in a Lightwell"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<TileWell> context) {
            TypedLuaObject<MetaWrapper<ItemStack>> stack = ContextHelpers.wrapStack(context, context.getTarget().getInventoryHandler().getStackInSlot(0));
            return stack != null ? Collections.singletonMap("catalyst", stack) : Collections.emptyMap();
        }
    };
    public static final IMetaProvider<TileCollectorCrystal> META_TILE_COLLECTOR_CRYSTAL = new BaseMetaProvider<TileCollectorCrystal>("Provides the CrystalProperties, attunement, and crystal type for a Collector Crystal"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<TileCollectorCrystal> context) {
            IMinorConstellation traitConstellation;
            HashMap<Object, Object> out = new HashMap<Object, Object>(4);
            TileCollectorCrystal target = context.getTarget();
            out.putAll(context.makePartialChild(target.getCrystalProperties()).getMeta());
            IWeakConstellation mainConstellation = target.getConstellation();
            if (mainConstellation != null) {
                out.put("constellation", context.makePartialChild(mainConstellation).getMeta());
            }
            if ((traitConstellation = target.getTrait()) != null) {
                out.put("traitConstellation", context.makePartialChild(traitConstellation).getMeta());
            }
            out.put("crystalType", target.getType().name());
            return out;
        }
    };
    public static final IMetaProvider<ItemStack> META_ITEM_COLLECTOR_CRYSTAL = new ItemStackContextMetaProvider<ItemCollectorCrystal>(ItemCollectorCrystal.class, "Provides the attunement and crystal type for a Collector Crystal in item form"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<ItemStack> context, @Nonnull ItemCollectorCrystal item) {
            IMinorConstellation traitConstellation;
            HashMap<String, Object> out = new HashMap<String, Object>(3);
            ItemStack stack = context.getTarget();
            IWeakConstellation mainConstellation = ItemCollectorCrystal.getConstellation((ItemStack)stack);
            if (mainConstellation != null) {
                out.put("constellation", context.makePartialChild(mainConstellation).getMeta());
            }
            if ((traitConstellation = ItemCollectorCrystal.getTrait((ItemStack)stack)) != null) {
                out.put("traitConstellation", context.makePartialChild(traitConstellation).getMeta());
            }
            out.put("crystalType", ItemCollectorCrystal.getType((ItemStack)stack).name());
            return out;
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            ItemStack stack = new ItemStack((Block)BlocksAS.collectorCrystal);
            CrystalProperties.applyCrystalProperties((ItemStack)stack, (CrystalProperties)CrystalProperties.getMaxRockProperties());
            ItemCollectorCrystal.setType((ItemStack)stack, (BlockCollectorCrystalBase.CollectorCrystalType)BlockCollectorCrystalBase.CollectorCrystalType.ROCK_CRYSTAL);
            ItemCollectorCrystal.setConstellation((ItemStack)stack, (IWeakConstellation)Constellations.discidia);
            ItemCollectorCrystal.setTraitConstellation((ItemStack)stack, (IMinorConstellation)Constellations.gelu);
            return stack;
        }
    };
    public static final IMetaProvider<TileCrystalLens> META_TILE_CRYSTAL_LENS = new BaseMetaProvider<TileCrystalLens>("Provides the CrystalProperties and lens color of a Crystal Lens"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<TileCrystalLens> context) {
            String colorName;
            HashMap<Object, Object> out = new HashMap<Object, Object>(3);
            TileCrystalLens target = context.getTarget();
            out.putAll(context.makePartialChild(target.getCrystalProperties()).getMeta());
            ItemColoredLens.ColorType lens = target.getLensColor();
            String string = colorName = lens != null ? lens.getUnlocalizedName() : null;
            if (colorName != null) {
                out.put("lensColor", colorName);
                out.put("lensColour", colorName);
            }
            return out;
        }
    };
    public static final IMetaProvider<TileGrindstone> META_GRINDSTONE = new BaseMetaProvider<TileGrindstone>("Provides the item currently on a Grindstone"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<TileGrindstone> context) {
            return Collections.singletonMap("item", context.makePartialChild(context.getTarget().getGrindingItem()).getMeta());
        }
    };
    public static final IMetaProvider<TileRitualPedestal> META_RITUAL_PEDESTAL = new BaseMetaProvider<TileRitualPedestal>("Provides the focus crystal and work status of a Ritual Pedestal"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<TileRitualPedestal> context) {
            HashMap<String, Object> out = new HashMap<String, Object>(2);
            TileRitualPedestal target = context.getTarget();
            out.put("focus", context.makePartialChild(target.getCatalystCache()).getMeta());
            out.put("isWorking", target.isWorking());
            return out;
        }
    };
    public static final IMetaProvider<TileIlluminator> META_CAVE_ILLUMINATOR = new BasicMetaProvider<TileIlluminator>("Provides the flare color for a Cave Illuminator"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull TileIlluminator context) {
            NBTTagCompound nbt = new NBTTagCompound();
            context.writeCustomNBT(nbt);
            if (!nbt.func_150297_b("wandColor", 3)) {
                return Collections.emptyMap();
            }
            HashMap<String, String> out = new HashMap<String, String>(2);
            EnumDyeColor color = EnumDyeColor.func_176764_b((int)nbt.func_74762_e("wandColor"));
            out.put("flareColor", color.toString());
            out.put("flareColour", color.toString());
            return out;
        }
    };
    public static final IMetaProvider<TileAttunementRelay> META_SPECTRAL_RELAY = new BaseMetaProvider<TileAttunementRelay>("Provides the item in a Spectral Relay"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<TileAttunementRelay> context) {
            return Collections.singletonMap("item", context.makePartialChild(context.getTarget().getInventoryHandler().getStackInSlot(0)).getMeta());
        }
    };
    public static final IMetaProvider<TileMapDrawingTable> META_STELLAR_REFRACTION_TABLE = new BaseMetaProvider<TileMapDrawingTable>("Provides the items in a Stellar Refraction Table"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<TileMapDrawingTable> context) {
            TypedLuaObject<MetaWrapper<ItemStack>> inputStack;
            HashMap<String, TypedLuaObject<MetaWrapper<ItemStack>>> out = new HashMap<String, TypedLuaObject<MetaWrapper<ItemStack>>>(2);
            TileMapDrawingTable target = context.getTarget();
            TypedLuaObject<MetaWrapper<ItemStack>> lensStack = ContextHelpers.wrapStack(context, target.getSlotGlassLens());
            if (lensStack != null) {
                out.put("infusedGlass", lensStack);
            }
            if ((inputStack = ContextHelpers.wrapStack(context, target.getSlotIn())) != null) {
                out.put("processingSlot", inputStack);
            }
            return out;
        }
    };

    private MetaBlocks() {
    }
}

