/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.tconstruct;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.squiddev.plethora.api.meta.TypedMeta;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.TypedLuaObject;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.api.reference.DynamicReference;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.library.smeltery.ISmelteryTankHandler;
import slimeknights.tconstruct.smeltery.tileentity.TileHeatingStructureFuelTank;
import slimeknights.tconstruct.smeltery.tileentity.TileMultiblock;
import slimeknights.tconstruct.smeltery.tileentity.TileSmelteryComponent;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;

public final class MethodsSmeltery {
    private MethodsSmeltery() {
    }

    @PlethoraMethod(modId="tconstruct", doc="function(fluid: number|string) -- Select which fluid will be extracted by drains in the smeltery. One can specify a fluid name or an index in list of molten fluids.")
    public static void selectMolten(@FromTarget ISmelteryTankHandler smeltery, Object[] args) throws LuaException {
        if (args.length >= 1 && args[0] instanceof String) {
            String fluid = (String)args[0];
            List fluids = smeltery.getTank().getFluids();
            for (int i = 0; i < fluids.size(); ++i) {
                Fluid stack = ((FluidStack)fluids.get(i)).getFluid();
                if (!stack.getName().equalsIgnoreCase(fluid) && !FluidRegistry.getDefaultFluidName((Fluid)stack).equalsIgnoreCase(fluid)) continue;
                smeltery.getTank().moveFluidToBottom(i);
                smeltery.onTankChanged(fluids, null);
                return;
            }
            throw new LuaException(String.format("Cannot find fluid '%s'", fluid));
        }
        int fluid = ArgumentHelper.getInt((Object[])args, (int)0);
        List fluids = smeltery.getTank().getFluids();
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(fluid, 1, fluids.size(), "Fluid out of range (%s)");
        smeltery.getTank().moveFluidToBottom(fluid - 1);
        smeltery.onTankChanged(fluids, null);
    }

    @PlethoraMethod(modId="tconstruct", doc="-- Get a list of all molten fluids within the smeltery.")
    public static Map<Integer, TypedMeta<FluidStack, ?>> getMolten(IContext<ISmelteryTankHandler> context) {
        ISmelteryTankHandler smeltery = (ISmelteryTankHandler)context.getTarget();
        HashMap result = new HashMap();
        int i = 0;
        for (FluidStack fluid : smeltery.getTank().getFluids()) {
            result.put(++i, context.makePartialChild(fluid).getMeta());
        }
        return result;
    }

    @PlethoraMethod(modId="tconstruct", doc="-- Get a list of all fuels currently used by the seared-bricks multiblock.")
    public static Map<Integer, TypedMeta<IFluidTank, ?>> getFuels(IContext<TileHeatingStructureFuelTank<?>> context) {
        TileHeatingStructureFuelTank structure = (TileHeatingStructureFuelTank)context.getTarget();
        HashMap result = new HashMap();
        int i = 0;
        for (BlockPos pos : structure.tanks) {
            FluidTankAnimated internal;
            TileEntity te = MethodsSmeltery.getRelatedTile((TileEntity)structure, pos);
            if (!(te instanceof TileTank) || (internal = ((TileTank)te).getInternalTank()) == null || internal.getFluid() == null || !TinkerRegistry.isSmelteryFuel((FluidStack)internal.getFluid())) continue;
            result.put(++i, context.makePartialChild(internal).getMeta());
        }
        return result;
    }

    @PlethoraMethod(modId="tconstruct", doc="-- Get the internal temperature of this structure.")
    public static double getTemperature(@FromTarget TileHeatingStructureFuelTank<?> structure) {
        return structure.getTemperature();
    }

    @Optional
    @PlethoraMethod(modId="tconstruct", doc="-- Get the controller for this smeltery component.")
    public static TypedLuaObject<TileMultiblock> getController(IContext<TileSmelteryComponent> context) {
        TileSmelteryComponent component = (TileSmelteryComponent)context.getTarget();
        if (!component.getHasMaster()) {
            return null;
        }
        TileEntity te = MethodsSmeltery.getRelatedTile((TileEntity)component, component.getMasterPosition());
        if (!(te instanceof TileMultiblock)) {
            return null;
        }
        return context.makeChild((TileMultiblock)te, new ControllerReference(component, (TileMultiblock)te)).getObject();
    }

    @Nullable
    private static TileEntity getRelatedTile(TileEntity component, BlockPos pos) {
        World world = component.func_145831_w();
        return world.func_175667_e(pos) ? world.func_175625_s(pos) : null;
    }

    private static final class ControllerReference
    implements DynamicReference<TileMultiblock> {
        private final TileSmelteryComponent origin;
        private final TileMultiblock<?> expected;

        private ControllerReference(TileSmelteryComponent origin, TileMultiblock<?> expected) {
            this.origin = origin;
            this.expected = expected;
        }

        @Override
        @Nonnull
        public TileMultiblock get() throws LuaException {
            if (!this.origin.getHasMaster() || MethodsSmeltery.getRelatedTile((TileEntity)this.origin, this.origin.getMasterPosition()) != this.expected) {
                throw new LuaException("The controller has changed");
            }
            return this.expected;
        }

        @Override
        @Nonnull
        public TileMultiblock safeGet() {
            return this.expected;
        }
    }
}

