/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.commands;

import com.erigitic.config.AccountManager;
import com.erigitic.config.TEAccount;
import com.erigitic.config.TECurrency;
import com.erigitic.main.TotalEconomy;
import com.erigitic.util.MessageManager;
import java.util.HashMap;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class BalanceCommand
implements CommandExecutor {
    private TotalEconomy totalEconomy;
    private AccountManager accountManager;
    private MessageManager messageManager;
    private Currency defaultCurrency;

    public BalanceCommand(TotalEconomy totalEconomy, AccountManager accountManager, MessageManager messageManager) {
        this.totalEconomy = totalEconomy;
        this.accountManager = accountManager;
        this.messageManager = messageManager;
        this.defaultCurrency = totalEconomy.getDefaultCurrency();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (!(src instanceof Player)) throw new CommandException((Text)Text.of((String)"[TE] This command can only be run by a player!"));
        Player sender = (Player)src;
        TEAccount playerAccount = (TEAccount)this.accountManager.getOrCreateAccount(sender.getUniqueId()).get();
        Optional optCurrencyName = args.getOne("currencyName");
        HashMap<String, String> messageValues = new HashMap<String, String>();
        if (optCurrencyName.isPresent()) {
            Optional<Currency> optCurrency = this.totalEconomy.getTECurrencyRegistryModule().getById("totaleconomy:" + ((String)optCurrencyName.get()).toLowerCase());
            if (!optCurrency.isPresent()) throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "[TE] The specified currency does not exist!"}));
            TECurrency currency = (TECurrency)optCurrency.get();
            messageValues.put("currency", currency.getName());
            messageValues.put("amount", currency.format(playerAccount.getBalance(currency)).toPlain());
            sender.sendMessage(this.messageManager.getMessage("command.balance.other", messageValues));
            return CommandResult.success();
        } else {
            messageValues.put("amount", this.defaultCurrency.format(playerAccount.getBalance(this.defaultCurrency)).toPlain());
            sender.sendMessage(this.messageManager.getMessage("command.balance.default", messageValues));
        }
        return CommandResult.success();
    }
}

