/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.List;
import me.desht.pneumaticcraft.client.model.module.ModelFlowDetector;
import me.desht.pneumaticcraft.client.model.module.ModelModuleBase;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.block.tubes.IInfluenceDispersing;
import me.desht.pneumaticcraft.common.block.tubes.TubeModuleRedstoneEmitting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class ModuleFlowDetector
extends TubeModuleRedstoneEmitting
implements IInfluenceDispersing {
    public float rotation;
    public float oldRotation;
    private int flow;
    private int oldFlow;

    @Override
    public void update() {
        super.update();
        this.oldRotation = this.rotation;
        this.rotation += (float)this.getRedstoneLevel() / 100.0f;
        if (!this.pressureTube.world().field_72995_K) {
            if (this.setRedstone(this.flow / 5)) {
                this.sendDescriptionPacket();
            }
            this.oldFlow = this.flow;
            this.flow = 0;
        }
    }

    @Override
    public String getType() {
        return "flow_detector_module";
    }

    @Override
    public int getMaxDispersion() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onAirDispersion(int amount) {
        this.flow += amount;
    }

    @Override
    public void addInfo(List<String> curInfo) {
        super.addInfo(curInfo);
        curInfo.add("Flow: " + TextFormatting.WHITE + this.oldFlow + " mL/tick");
        super.addInfo(curInfo);
    }

    @Override
    public boolean isInline() {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.rotation = tag.func_74760_g("rotation");
        this.oldFlow = tag.func_74762_e("flow");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74776_a("rotation", this.rotation);
        tag.func_74768_a("flow", this.oldFlow);
    }

    @Override
    public boolean canUpgrade() {
        return false;
    }

    @Override
    protected GuiHandler.EnumGuiId getGuiId() {
        return null;
    }

    @Override
    public Class<? extends ModelModuleBase> getModelClass() {
        return ModelFlowDetector.class;
    }
}

