/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public class FluidUtils {
    public static boolean tryFluidExtraction(IFluidHandler srcHandler, ItemStack destStack, NonNullList<ItemStack> returnedItems) {
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)destStack, (IFluidHandler)srcHandler, (int)1000, null, (boolean)true);
        if (result.isSuccess()) {
            returnedItems.add((Object)result.getResult());
            destStack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public static boolean tryFluidInsertion(IFluidHandler handler, ItemStack srcStack, NonNullList<ItemStack> returnedItems) {
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)srcStack, (IFluidHandler)handler, (int)1000, null, (boolean)true);
        if (result.isSuccess()) {
            returnedItems.add((Object)result.getResult());
            srcStack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public static boolean tryFluidInsertion(TileEntity te, EnumFacing face, EntityPlayer player, EnumHand hand) {
        return FluidUtils.doFluidInteraction(te, face, player, hand, true);
    }

    public static boolean tryFluidExtraction(TileEntity te, EnumFacing face, EntityPlayer player, EnumHand hand) {
        return FluidUtils.doFluidInteraction(te, face, player, hand, false);
    }

    private static boolean doFluidInteraction(TileEntity te, EnumFacing face, EntityPlayer player, EnumHand hand, boolean isInserting) {
        ItemStack stack = player.func_184586_b(hand);
        IFluidHandlerItem stackHandler = FluidUtil.getFluidHandler((ItemStack)stack);
        if (stackHandler != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face)) {
            FluidActionResult result;
            IFluidTankProperties[] properties = stackHandler.getTankProperties();
            if (properties.length == 0) {
                return false;
            }
            int capacity = properties[0].getCapacity();
            IFluidHandler handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face);
            PlayerInvWrapper invWrapper = new PlayerInvWrapper(player.field_71071_by);
            FluidActionResult fluidActionResult = result = isInserting ? FluidUtil.tryEmptyContainerAndStow((ItemStack)player.func_184586_b(hand), (IFluidHandler)handler, (IItemHandler)invWrapper, (int)capacity, (EntityPlayer)player, (boolean)true) : FluidUtil.tryFillContainerAndStow((ItemStack)player.func_184586_b(hand), (IFluidHandler)handler, (IItemHandler)invWrapper, (int)capacity, (EntityPlayer)player, (boolean)true);
            if (result.isSuccess()) {
                player.func_184611_a(hand, result.getResult());
                return true;
            }
        }
        return false;
    }

    public static boolean isSourceBlock(World world, BlockPos pos) {
        return FluidUtils.isSourceBlock(world, pos, null);
    }

    public static boolean isSourceBlock(World world, BlockPos pos, Fluid fluid) {
        IFluidHandler handler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)EnumFacing.UP);
        if (handler != null) {
            FluidStack fluidStack = handler.drain(1000, false);
            return fluidStack != null && fluidStack.amount == 1000 && (fluid == null || fluidStack.getFluid().getName().equals(fluid.getName()));
        }
        return false;
    }

    public static FluidStack getFluidAt(World world, BlockPos pos, boolean doDrain) {
        IFluidHandler handler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)EnumFacing.UP);
        return handler != null ? handler.drain(1000, doDrain) : null;
    }
}

