/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.Ic2Crops;
import ic2.core.block.crop.TileEntityCrop;
import ic2.core.block.crop.crops.CropCardBase;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropTerraWart
extends CropCardBase {
    public CropTerraWart() {
        super(new CropProperties(5, 2, 4, 0, 3, 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state == 1) {
            return this.getSprite("bc")[37];
        }
        return this.getSprite("bc")[38 + state];
    }

    @Override
    public String getId() {
        return "TerraWart";
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Blue", "Aether", "Consumable", "Snow"};
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 3;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 3;
    }

    @Override
    public double dropGainChance() {
        return 0.8;
    }

    @Override
    public int getMaxSize() {
        return 3;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return Ic2Items.terraWart.func_77946_l();
    }

    @Override
    public void tick(ICropTile cropTile) {
        if (cropTile.isBlockBelow(Blocks.field_150433_aE)) {
            if (this.canGrow(cropTile) && cropTile instanceof TileEntityCrop) {
                TileEntityCrop crop = (TileEntityCrop)cropTile;
                crop.setGrowthPoints(crop.getGrowthPoints() + crop.calculateGrowth() / 2);
            }
        } else if (cropTile.isBlockBelow(Blocks.field_150425_aM) && this.getWorld((ICropTile)cropTile).field_73012_v.nextInt(300) == 0) {
            cropTile.setCrop(Ic2Crops.cropNetherWart);
        }
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 3;
    }
}

