/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components;

import ic2.core.inventory.gui.GuiIC2;
import ic2.core.util.math.Box2D;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GuiComponent {
    public Box2D position;

    public GuiComponent(Box2D box) {
        this.position = box;
    }

    public Box2D getPosition() {
        return this.position;
    }

    public abstract List<ActionRequest> getNeededRequests();

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.position.isInBox(mouseX, mouseY);
    }

    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
    }

    @SideOnly(value=Side.CLIENT)
    public void onGuiTick(GuiIC2 gui) {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
    }

    @SideOnly(value=Side.CLIENT)
    public void postDraw(GuiIC2 gui, int mouseX, int mouseY) {
    }

    @SideOnly(value=Side.CLIENT)
    public void onToolTipCollecting(GuiIC2 gui, int mouseX, int mouseY, List<String> tooltips) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onMouseClick(GuiIC2 gui, int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onKeyTyped(GuiIC2 gui, char keyTyped, int keyCode) {
        return false;
    }

    public static enum ActionRequest {
        GuiInit,
        GuiTick,
        BackgroundDraw,
        FrontgroundDraw,
        PostDraw,
        ToolTip,
        MouseClick,
        KeyPressed,
        ButtonNotify;

    }
}

