/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.machine;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.recipe.machine.ISawmillOutput;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IFakeMachine;
import ic2.api.classic.tile.IMachine;
import ic2.api.classic.tile.ISawMill;
import ic2.core.item.upgrades.subtypes.machine.BaseMetaUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SawBladeUpgrade
extends BaseMetaUpgrade {
    int max;
    boolean adv;

    public SawBladeUpgrade(boolean adv, int maximum) {
        this.adv = adv;
        this.max = maximum;
    }

    @Override
    public void onProcessEndPre(ItemStack upgrade, IMachine machine, MachineOutput output) {
        if (machine instanceof ISawMill && output instanceof ISawmillOutput) {
            int used = this.getUsesDone(upgrade);
            if (used >= this.max) {
                return;
            }
            if (((ISawmillOutput)((Object)output)).increaseResuls(this.adv ? 2 : 4)) {
                this.setUsesDone(upgrade, ++used);
            }
        }
    }

    @Override
    public int getExtraEnergyDemand(ItemStack upgrade, IMachine machine) {
        if (machine instanceof ISawMill || machine instanceof IFakeMachine) {
            return this.adv ? 2 : 1;
        }
        return 0;
    }

    @Override
    public int getExtraProcessSpeed(ItemStack upgrade, IMachine machine) {
        if (machine instanceof ISawMill || machine instanceof IFakeMachine) {
            return this.adv ? 4 : 2;
        }
        return 0;
    }

    @Override
    public IMachineUpgradeItem.UpgradeType getType() {
        return IMachineUpgradeItem.UpgradeType.Processing;
    }

    @Override
    public LocaleComp getName() {
        return this.adv ? Ic2ItemLang.durableSawbladeUpgrade : Ic2ItemLang.efficientSawbladeUpgrade;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture() {
        return Ic2Icons.getTextures("i0")[this.adv ? 165 : 164];
    }

    @Override
    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    @Override
    public void addInfo(ItemStack par1, EntityPlayer par2, List<String> par3, Map<ToolTipType, List<String>> toolTips) {
        List<String> shiftInfo = toolTips.get((Object)ToolTipType.Shift);
        shiftInfo.add(Ic2InfoLang.extraDrops.getLocalizedFormatted(this.adv ? 2 : 4));
        shiftInfo.add(Ic2InfoLang.durabilityLeft.getLocalizedFormatted(this.max - this.getUsesDone(par1), this.max));
    }

    public int getUsesDone(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74762_e("Used");
    }

    public void setUsesDone(ItemStack stack, int use) {
        StackUtil.getOrCreateNbtData(stack).func_74768_a("Used", use);
    }
}

