/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.config;

import ic2.core.platform.config.ConfigEntry;
import ic2.core.platform.config.IC2Config;
import ic2.core.platform.config.components.callbacks.SteelCallback;
import ic2.core.platform.config.components.checker.RangeChecker;
import ic2.core.platform.config.components.checker.RangeCheckerFloat;
import ic2.core.platform.config.components.checker.SesonalChecker;
import ic2.core.platform.config.components.checker.SuddenHoeChecker;
import ic2.core.platform.config.components.notifies.MainNotify;
import java.util.ArrayList;
import java.util.List;

class ConfigDefaults {
    List<ConfigEntry> defaults = new ArrayList<ConfigEntry>();

    ConfigDefaults(IC2Config config) {
        this.init(config);
    }

    private void init(IC2Config config) {
        IC2Config.ConfigType flag = IC2Config.ConfigType.Boolean;
        IC2Config.ConfigType innr = IC2Config.ConfigType.Integer;
        IC2Config.ConfigType ronr = IC2Config.ConfigType.Float;
        IC2Config.ConfigType text = IC2Config.ConfigType.String;
        this.add(new ConfigEntry(flag, "crafting", "enableCraftingBucket", "Enable crafting of buckets out of tin", "CraftingBucket", true).setGameRestart().setServerSync());
        this.add(new ConfigEntry(flag, "crafting", "enableCraftingGlowstoneDust", "Enable crafting of glowstone dust out of dusts", "CraftingGlowstoneDust", true).setGameRestart().setServerSync());
        this.add(new ConfigEntry(flag, "crafting", "enableCraftingGunpowder", "Enable crafting of gunpowder out of dusts", "CraftingGunpowder", true).setGameRestart().setServerSync());
        this.add(new ConfigEntry(flag, "crafting", "enableCraftingITnt", "Enable crafting of ITNT", "CraftingITNT", true).setGameRestart().setServerSync());
        this.add(new ConfigEntry(flag, "crafting", "enableCraftingNuke", "Enable crafting of nukes", "CraftingNuke", true).setGameRestart().setServerSync());
        this.add(new ConfigEntry(flag, "crafting", "enableCraftingRail", "Enable crafting of rails out of bronze", "CraftingRail", true).setGameRestart().setServerSync());
        this.add(new ConfigEntry(flag, "crafting", "enableCraftingPiston", "Enable crafting of Piston out of bronze or silver", "CraftingPiston", true).setGameRestart().setServerSync());
        this.add(new ConfigEntry(flag, "crafting", "enableSecretRecipeHiding", "Enable hiding of secret recipes in CraftGuide/NEI/Jei", "SecretRecipeHiding", true));
        this.add(new ConfigEntry(flag, "crafting", "enableFurnaceRecipeVanillaShare", "Enable that Furnace Recipes that get added by the IC2 api get automaticly applied to Vanilla", "enableFurnaceRecipeVanillaShare", false).setGameRestart().setServerSync());
        this.add(new ConfigEntry(text, "crafting", "recyclerBlacklist", "List of blocks and items which should not be turned into scrap by the recycler. Comma separated, format is id(Block/ItemName)-metadata or use ore:oreID to exclude OreDictionary Entries", "recyclerBlacklist", "minecraft:glass_pane, minecraft:stick, minecraft:snowball, IC2:scaffold").setGameRestart().setServerSync());
        this.add(new ConfigEntry(flag, "crafting", "disableBronzeTools", "Disable the Recipes From Bronze Tools and Armors", "dissableBronzeTools", false).setGameRestart().setServerSync());
        this.add(new ConfigEntry(flag, "crafting", "enableSteelRecipes", "Enable that Refined Iron gets replaced with Steel in Recipes", "SteelRecipes", false).addCallback(new SteelCallback()).setGameRestart().setServerSync());
        this.add(new ConfigEntry(flag, "worldgen", "enableWorldGenTreeRubber", "Enable generation of rubber trees in the world", "WorldGenTreeRubber", true));
        this.add(new ConfigEntry(flag, "worldgen", "enableWorldGenOreCopper", "Enable generation of copper in the world", "WorldGenOreCopper", true));
        this.add(new ConfigEntry(flag, "worldgen", "enableWorldGenOreSilver", "Enable generation of silver in the world", "WorldGenOreSilver", true));
        this.add(new ConfigEntry(flag, "worldgen", "enableWorldGenOreTin", "Enable generation of tin in the world", "WorldGenOreTin", true));
        this.add(new ConfigEntry(flag, "worldgen", "enableWorldGenOreUranium", "Enable generation of uranium in the world", "WorldGenOreUranium", true));
        this.add(new ConfigEntry(ronr, "worldgen", "oreDensityFactor", "Factor to adjust the ore generation rate", "oreDensityFactor", Float.valueOf(1.0f)));
        this.add(new ConfigEntry(flag, "features", "enableQuantumSpeedOnSprint", "Enable activation of the quantum leggings' speed boost when sprinting instead of holding the boost key", "QuantumSpeedOnSprint", true));
        this.add(new ConfigEntry(flag, "features", "enableChargePadUpgradeAnySide", "Enable that you can upgrade Chargepads from any side", "ChargePadUpgradeAnySide", false));
        this.add(new ConfigEntry(flag, "features", "enableTeleporterInventory", "Enable calculation of inventory weight when going through a teleporter", "TeleporterInventory", true));
        this.add(new ConfigEntry(flag, "features", "enableIC2EasyMode", "Enable IC2 easy mode dissables explosions of Machines and melting of cables", "IC2EasyMode", false));
        this.add(new ConfigEntry(flag, "features", "enableSpecialElectricArmor", "Enables the feature that electric armor absorbs Electric Damage", "SpecialElectricArmor", true));
        this.add(new ConfigEntry(flag, "features", "enableMinerLapotron", "Enable usage of lapotron crystals on miners", "MinerLapotron", true).setServerSync());
        this.add(new ConfigEntry(flag, "features", "enableBurningScrap", "Enable burning of scrap in a generator", "BurningScrap", true).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(flag, "features", "enableHardEnrichedUran", "Enable Harder Enriched Uranium Processing. Making it not so easy to create", "HardEnrichedUran", false).setGameRestart().setServerSync());
        this.add(new ConfigEntry(flag, "features", "enableElytraWindEffect", "Enables on the ServerSide that Wind Can Effect EytraFlight", "ElytraServer", false).setGameRestart());
        this.add(new ConfigEntry(flag, "features", "enableElytraPlayerEffect", "Enables for the Player to be Effected by the WindEffect", "ElytraClient", false).setWorldRestart());
        this.add(new ConfigEntry(innr, "features", "reactorPlannerMaxTicks", "Sets the max tick per tick config in the ReactorPlanner", "reactorPlannerMaxTicks", 1000).addLimiter(new RangeChecker(10, false)));
        this.add(new ConfigEntry(ronr, "features", "enableEnergyBurn", "Enables that whenever a cable burns or a machine explodes a fire can spawn. Range: 0-1. 0 = Dissabled (0%) 1 = 100%", "energyBurn", Float.valueOf(0.0f)).addLimiter(new RangeCheckerFloat(0.0f, 1.0f)));
        this.add(new ConfigEntry(innr, "features", "enetRenderLimit", "Sets the Render Limit for the Enet Renderer. Increasing can cause more lag when activly used default: 5", "renderLimit", 5).addLimiter(new RangeChecker(5, false)));
        this.add(new ConfigEntry(flag, "features", "forcePlateEntries", "Registers IC2Classic Ingots as IC2Exps Plate Entries if there is no other entries. This is basically the override to force the entries in even so there are other entries present", "plateOverride", false).setGameRestart().setServerSync());
        this.add(new ConfigEntry(flag, "features", "enableBeaconJoke", "Enables that beacons have a surprise if you use uranium as base. Checkt client & server side. So every player has control over it", "nukeStuff", true));
        this.add(new ConfigEntry(flag, "features", "enableVillagers", "Enables IC2Classic Villager Trades. If disabled they still spawn but have no trades", "Villagers", true));
        this.add(new ConfigEntry(flag, "features", "enableGreg", "Enables Greg Villager Trades. (Disabling can not revert already existing greg trades)", "BlameGreg", true));
        this.add(new ConfigEntry(flag, "features", "enableInfiniteNetherLava", "Enables that the 1 Block Pumps produce infinite Lava in the nether", "NetherLava", false));
        this.add(new ConfigEntry(flag, "gags", "enableSuddenlyHoes", "", "SuddenlyHoes", false).setHiddingConfig().addLimiter(new SuddenHoeChecker()));
        this.add(new ConfigEntry(flag, "gags", "enableSeasonal", "", "Seasonal", false).setHiddingConfig().addLimiter(new SesonalChecker()));
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorBase", "Base energy generation values - increase those for higher energy yield", "energyGeneratorBase", 10).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(ronr, "balance", "energyGeneratorScrap", "", "ScrapGenerator", Float.valueOf(12.5f)).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorLiquid", "", "liquidGenerator", 100).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorGeo", "", "energyGeneratorGeo", 20).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorThermal", "", "thermalEnergy", 25).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(ronr, "balance", "energyGeneratorThermalPassive", "", "thermalEnergyPassive", Float.valueOf(1.0f)).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorWater", "", "energyGeneratorWater", 100).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorWaterLV", "", "energyGeneratorWaterLV", 100).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorWaterMV", "", "energyGeneratorWaterMV", 100).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorWaterHV", "", "energyGeneratorWaterHV", 100).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorWave", "", "energyGeneratorWave", 100).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorOcean", "", "energyGeneratorOcean", 100).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorSolar", "", "energyGeneratorSolar", 100).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorSolarLV", "", "energyGeneratorSolarLV", 100).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorSolarMV", "", "energyGeneratorSolarMV", 100).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorSolarHV", "", "energyGeneratorSolarHV", 100).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorSolarTurbine", "", "energyGeneratorSolarTurbine", 100).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorWind", "", "energyGeneratorWind", 100).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(innr, "balance", "energyGeneratorNuclear", "", "energyGeneratorNuclear", 5).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(ronr, "balance", "electricSuitAbsorbtionScale", "Sets the Absorbtion Ratio of Electric Armor", "electricSuitAbsorbtionScale", Float.valueOf(1.0f)).addLimiter(new RangeCheckerFloat(0.1f, false)));
        this.add(new ConfigEntry(ronr, "balance", "electricSuitEnergyCostModifier", "Modifies the Energy Cost per damage", "electricSuitEnergyCostModifier", Float.valueOf(1.0f)).addLimiter(new RangeCheckerFloat(0.0f, false)));
        this.add(new ConfigEntry(innr, "balance", "cropDifficulty", "Defines the Difficulty Level of Crops. 0 = Very Easy, 1 = Easy, 2 = Normal, 3 = Hard. This effects CropGrowth, Breeding, And StatBreeding", "CropDifficulty", 2).addLimiter(new RangeChecker(0, 3)).setWorldRestart());
        this.add(new ConfigEntry(innr, "balance", "RFPerEU", "This config defines how much RF you get per EU. Default = 8", "RFPerEU", 8).addLimiter(new RangeChecker(0, false)).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(ronr, "balance", "EUPerUU", "This config is a multiplier that allows you to modify the cost of EU per UUMatter. Needs to be synced between client & server else progress issues come up. Default: 1, range: min: 0.01 - max: 1900", "uuEU", 1).addLimiter(new RangeCheckerFloat(0.01f, false)).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(flag, "balance", "UUNeedsScrap", "This config sets the massfabricator to require amplifier to produce UUMatter. The cheapining Rules apply still. +5Progress per Amplifier", "UUScrap", false).setWorldRestart().setServerSync());
        this.add(new ConfigEntry(ronr, "world", "explosionPowerNuke", "Explosion power of a nuke, where TNT is 4", "explosionPowerNuke", Float.valueOf(35.0f)));
        this.add(new ConfigEntry(ronr, "world", "explosionPowerReactorMax", "Maximum explosion power of a nuclear reactor, where TNT is 4", "explosionPowerReactorMax", Float.valueOf(45.0f)));
        this.add(new ConfigEntry(innr, "world", "maxWindChangeDelay", "Sets the Maxium Time for the WindSimulator to Update.", "maxWindChangeDelay", 6000));
        this.add(new ConfigEntry(innr, "world", "maxWindStreams", "change how many wind streams exist, nr between 1-20", "maxWindStreams", 5).addLimiter(new RangeChecker(1, 20)).setWorldRestart());
        this.add(new ConfigEntry(flag, "world", "useRealisticWind", "enables the Realistic Wind Simulator. Makes the Classic Windmills anywhere efficent but less worth", "useRealisticWind", false).setWorldRestart());
        this.add(new ConfigEntry(flag, "sounds", "enableSounds", "", "enableSounds", true));
        this.add(new ConfigEntry(ronr, "sounds", "Master Sound Volume", "Master Volume that you can change ingame. Please do not change it. If you really want to then do a number between 0-1", "masterVolume", Float.valueOf(0.5f)).addLimiter(new RangeCheckerFloat(0.0f, 1.0f)));
        this.add(new ConfigEntry(ronr, "sounds", "Tile Sound Volume", "Master Volume for all Machines from IC2. Please do not change it. If you really want to then do a number between 0-1", "blockMasterVolume", Float.valueOf(1.0f)).addLimiter(new RangeCheckerFloat(0.0f, 1.0f)));
        this.add(new ConfigEntry(ronr, "sounds", "Equippet Item Sound Volume", "Master Volume for all Items that play Sounds in your Hand from IC2. Please do not change it. If you really want to then do a number between 0-1", "currentItemMasterVolume", Float.valueOf(1.0f)).addLimiter(new RangeCheckerFloat(0.0f, 1.0f)));
        this.add(new ConfigEntry(ronr, "sounds", "Backpack Sound Volume", "Master Volume for all Backpack Items that play Sounds from IC2. Please do not change it. If you really want to then do a number between 0-1", "currentBackpackMasterVolume", Float.valueOf(1.0f)).addLimiter(new RangeCheckerFloat(0.0f, 1.0f)));
        this.add(new ConfigEntry(flag, "client", "enableKeysInGuis", "Enable IC2 Keybinding Detection is active even if a gui is Open", "KeysInGuis", true));
        this.add(new ConfigEntry(innr, "client", "cropRenderMode", "Custom Config to ensure a CropRendering mode, 0 = Fancy, 1 = MCRenderSettings, 2 = Fast. IC2Classic does not change anything there at the moment. But if a addon changes crop Renderring that is here to control it", "cropRenderMode", 1).addLimiter(new RangeChecker(0, 2)));
        config.addConfigNotify(new MainNotify());
    }

    private void add(ConfigEntry par1) {
        this.defaults.add(par1);
    }

    public List<ConfigEntry> getDefaults() {
        return new ArrayList<ConfigEntry>(this.defaults);
    }
}

