/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import ic2.api.item.IC2Items;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.Recipes;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.api.EnumEntryType;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.ItemEntry;
import thelm.jaopca.api.ItemEntryGroup;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.ModuleBase;
import thelm.jaopca.api.utils.Utils;

public class ModuleIndustrialCraft
extends ModuleBase {
    public static final ItemEntry CRUSHED_ENTRY = new ItemEntry(EnumEntryType.ITEM, "crushed", new ModelResourceLocation("jaopca:crushed#inventory"), (Collection<String>)ImmutableList.of((Object)"Copper", (Object)"Gold", (Object)"Iron", (Object)"Lead", (Object)"Tin", (Object)"Silver", (Object)"Uranium"));
    public static final ItemEntry PURIFIED_ENTRY = new ItemEntry(EnumEntryType.ITEM, "crushedPurified", new ModelResourceLocation("jaopca:crushed_purified#inventory"), (Collection<String>)ImmutableList.of((Object)"Copper", (Object)"Gold", (Object)"Iron", (Object)"Lead", (Object)"Tin", (Object)"Silver", (Object)"Uranium"));

    @Override
    public String getName() {
        return "industrialcraft";
    }

    @Override
    public List<String> getDependencies() {
        return Lists.newArrayList((Object[])new String[]{"dust", "tinydust"});
    }

    public List<ItemEntryGroup> getItemRequests() {
        return Lists.newArrayList((Object[])new ItemEntryGroup[]{ItemEntryGroup.of(CRUSHED_ENTRY, PURIFIED_ENTRY)});
    }

    @Override
    public void init() {
        ItemStack stoneDust = IC2Items.getItem((String)"dust", (String)"stone");
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"crushed")) {
            ModuleIndustrialCraft.addMaceratorRecipe(Recipes.inputFactory.forOreDict("ore" + entry.getOreName()), Utils.getOreStack("crushed", entry, 2));
            ModuleIndustrialCraft.addCentrifugeRecipe(Recipes.inputFactory.forOreDict("crushed" + entry.getOreName()), Utils.energyI(entry, 1500.0), Utils.getOreStack("dust", entry, 1), Utils.getOreStackExtra("dustTiny", entry, 2), stoneDust.func_77946_l());
            ModuleIndustrialCraft.addOreWashingRecipe(Recipes.inputFactory.forOreDict("crushed" + entry.getOreName()), Utils.getOreStack("crushedPurified", entry, 1), Utils.getOreStack("dustTiny", entry, 2), stoneDust.func_77946_l());
            Utils.addSmelting(Utils.getOreStack("crushed", entry, 1), Utils.getOreStack("ingot", entry, 1), 0.2f);
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"crushedPurified")) {
            ModuleIndustrialCraft.addCentrifugeRecipe(Recipes.inputFactory.forOreDict("crushedPurified" + entry.getOreName()), Utils.energyI(entry, 1500.0), Utils.getOreStack("dust", entry, 1), Utils.getOreStackExtra("dustTiny", entry, 1));
            Utils.addSmelting(Utils.getOreStack("crushedPurified", entry, 1), Utils.getOreStack("ingot", entry, 1), 0.2f);
        }
    }

    @Override
    public List<Pair<String, String>> remaps() {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"purified", (Object)"crushedPurified")});
    }

    public static IRecipeInput getRecipeInput(Object input) {
        Pair pair;
        IRecipeInput ri = null;
        if (input instanceof String) {
            ri = Recipes.inputFactory.forOreDict((String)input);
        }
        if (input instanceof Pair && (pair = (Pair)input).getLeft() instanceof String && pair.getRight() instanceof Integer) {
            ri = Recipes.inputFactory.forOreDict((String)pair.getLeft(), ((Integer)pair.getRight()).intValue());
        }
        if (input instanceof ItemStack) {
            ri = Recipes.inputFactory.forStack((ItemStack)input);
        }
        if (input instanceof Fluid) {
            ri = Recipes.inputFactory.forFluidContainer((Fluid)input);
        }
        if (input instanceof FluidStack) {
            FluidStack fs = (FluidStack)input;
            ri = Recipes.inputFactory.forFluidContainer(fs.getFluid(), fs.amount);
        }
        if (input instanceof IRecipeInput) {
            ri = (IRecipeInput)input;
        }
        return ri;
    }

    public static void addMaceratorRecipe(Object input, ItemStack output) {
        Recipes.macerator.addRecipe(ModuleIndustrialCraft.getRecipeInput(input), null, false, new ItemStack[]{output});
    }

    public static void addCentrifugeRecipe(Object input, int minHeat, ItemStack ... output) {
        NBTTagCompound metadata = new NBTTagCompound();
        metadata.func_74768_a("minHeat", minHeat);
        Recipes.centrifuge.addRecipe(ModuleIndustrialCraft.getRecipeInput(input), metadata, false, output);
    }

    public static void addOreWashingRecipe(Object input, ItemStack ... output) {
        NBTTagCompound metadata = new NBTTagCompound();
        metadata.func_74768_a("amount", 1000);
        Recipes.oreWashing.addRecipe(ModuleIndustrialCraft.getRecipeInput(input), metadata, false, output);
    }

    public static void addCompressorRecipe(Object input, ItemStack output) {
        Recipes.compressor.addRecipe(ModuleIndustrialCraft.getRecipeInput(input), null, false, new ItemStack[]{output});
    }

    public static void addRollingRecipe(Object input, ItemStack output) {
        Recipes.metalformerRolling.addRecipe(ModuleIndustrialCraft.getRecipeInput(input), null, false, new ItemStack[]{output});
    }

    public static void addBlockCutterRecipe(Object input, int hardness, ItemStack output) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("hardness", hardness);
        Recipes.blockcutter.addRecipe(ModuleIndustrialCraft.getRecipeInput(input), nbt, false, new ItemStack[]{output});
    }
}

