/*
 * Decompiled with CFR 0.152.
 */
package thelm.oredictinit.registry;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import thelm.oredictinit.api.ICompat;
import thelm.oredictinit.api.OreDictInitApi;
import thelm.oredictinit.api.Woodchopper;
import thelm.oredictinit.lib.Data;

public class OreDictRegisCore {
    public static void initCompat() {
        for (ICompat compat : OreDictInitApi.ORE_DICT_COMPAT_LIST) {
            compat.register();
        }
    }

    public static void initCustom() {
        int i;
        String[] damageValues;
        String[] entries;
        String[] rawData;
        Woodchopper.info("Loading Custom Block Entries");
        for (String whole : Data.definedThingyBlocks) {
            block5: for (String custom : whole.split(";")) {
                Woodchopper.debug("Trying to load block entry " + custom);
                rawData = custom.trim().split(",");
                if (rawData.length == 4) {
                    entries = rawData[0].split("\\+");
                    if (entries.length == (damageValues = rawData[3].split("\\+")).length) {
                        for (i = 0; i < entries.length; ++i) {
                            try {
                                Integer.parseInt(damageValues[i]);
                            }
                            catch (Throwable e) {
                                Woodchopper.warn("Entry " + custom + " has errored:");
                                Woodchopper.error(e.toString());
                                continue block5;
                            }
                            OreDictRegisCore.addCustomEntryB(entries[i].trim(), rawData[1].trim(), rawData[2].trim(), damageValues[i]);
                        }
                        continue;
                    }
                    Woodchopper.warn("Entry " + custom + " has errored:");
                    Woodchopper.warn("Number of entries is inequal to number of damage values.");
                    continue;
                }
                if (rawData.length == 1 && rawData[0].trim().isEmpty()) continue;
                Woodchopper.warn("Entry " + custom + " has errored:");
                Woodchopper.warn("Entry length is incorrect.");
            }
        }
        Woodchopper.info("Loading Custom Item Entries");
        for (String whole : Data.definedThingyItems) {
            block8: for (String custom : whole.split(";")) {
                Woodchopper.debug("Trying to load item entry " + custom);
                rawData = custom.trim().split(",");
                if (rawData.length == 4) {
                    entries = rawData[0].trim().split("\\+");
                    if (entries.length == (damageValues = rawData[3].trim().split("\\+")).length) {
                        for (i = 0; i < entries.length; ++i) {
                            try {
                                Integer.parseInt(damageValues[i]);
                            }
                            catch (Throwable e) {
                                Woodchopper.warn("Entry " + custom + " has errored:");
                                Woodchopper.error(e.toString());
                                continue block8;
                            }
                            OreDictRegisCore.addCustomEntryI(entries[i].trim(), rawData[1].trim(), rawData[2].trim(), damageValues[i].trim());
                        }
                        continue;
                    }
                    Woodchopper.warn("Entry " + custom + " has errored:");
                    Woodchopper.warn("Number of entries is inequal to number of damage values.");
                    continue;
                }
                if (rawData.length == 1 && !rawData[0].trim().isEmpty()) continue;
                Woodchopper.warn("Entry " + custom + " has errored:");
                Woodchopper.warn("Entry length is incorrect.");
            }
        }
    }

    public static void addCustomEntryB(String entry, String mod, String block, String damage) {
        int dam = Integer.parseInt(damage);
        Block thing = OreDictRegisCore.getBlock(mod, block);
        if (thing != Blocks.field_150350_a) {
            OreDictionary.registerOre((String)entry, (ItemStack)new ItemStack(thing, 1, dam));
        }
    }

    public static void addCustomEntryI(String entry, String mod, String item, String damage) {
        int dam = Integer.parseInt(damage);
        Item thing = OreDictRegisCore.getItem(mod, item);
        if (thing != null) {
            OreDictionary.registerOre((String)entry, (ItemStack)new ItemStack(thing, 1, dam));
        }
    }

    public static Block getBlock(String mod, String block) {
        Block target = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, block));
        return target;
    }

    public static Item getItem(String mod, String item) {
        Item target = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, item));
        return target;
    }
}

