/*
 * Decompiled with CFR 0.152.
 */
package net.rom.gctweaks.gc.features;

import micdoodle8.mods.galacticraft.core.entities.EntityMeteor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.rom.gctweaks.base.Feature;

public class OverworldComets
extends Feature {
    private static boolean overworldComets;
    private static double overworldCometSpawnRate;

    @Override
    public String[] category() {
        return new String[]{"overworld-comets"};
    }

    @Override
    public String comment() {
        return "have comets also drop in the overworld - extending realism even further";
    }

    @Override
    public void syncConfig(Configuration config, String[] category) {
        overworldComets = config.get(category[0], "overworldComets", false, "Set to true to enable comets in the Overworld").getBoolean();
        overworldCometSpawnRate = config.get(category[0], "overworldCometSpawnRate", 1.0, "Set to a value between 0.0 and 0.9 to decrease meteor spawn").getDouble();
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void entityLivingEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLiving;
        if (overworldComets && (entityLiving = event.getEntityLiving()) instanceof EntityPlayerMP) {
            this.onPlayerUpdate((EntityPlayerMP)entityLiving);
        }
    }

    private void onPlayerUpdate(EntityPlayerMP player) {
        this.meteors(player);
    }

    protected void meteors(EntityPlayerMP player) {
        EntityPlayer closestPlayer;
        int f;
        int e;
        World world = player.field_70170_p;
        if (world.field_73011_w.func_186058_p().func_186068_a() == 0 && (e = world.field_73012_v.nextInt(f = (int)(3750.0 * (1.0 / overworldCometSpawnRate)))) < 3 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
            int r = world.func_73046_m().func_184103_al().func_72395_o();
            int x = world.field_73012_v.nextInt(20) + 160;
            int z = world.field_73012_v.nextInt(20) - 10;
            double motX = world.field_73012_v.nextDouble() * 2.0 - 2.5;
            double motZ = world.field_73012_v.nextDouble() * 5.0 - 2.5;
            int px = MathHelper.func_76128_c((double)player.field_70165_t);
            if ((x + px >> 4) - (px >> 4) >= r) {
                x = ((px >> 4) + r << 4) - 1 - px;
            }
            EntityMeteor meteor = new EntityMeteor(world, player.field_70165_t + (double)x, 355.0, player.field_70161_v + (double)z, motX, 0.0, motZ, 1);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)meteor);
            }
        }
    }
}

