/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.crafting;

import cubex2.cs4.api.RecipeInput;
import cubex2.cs4.plugins.vanilla.tileentity.ItemHandlerTileEntity;
import cubex2.cs4.util.ItemHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class ItemHandlerMachine
extends ItemHandlerTileEntity {
    private final int inputSlots;
    private final int outputSlots;
    private final int fuelSlots;
    private final IItemHandlerModifiable inputHandler;
    private final IItemHandlerModifiable outputHandler;
    private final IItemHandlerModifiable fuelHandler;

    public ItemHandlerMachine(int inputSlots, int outputSlots, int fuelSlots, TileEntity tile) {
        super(inputSlots + outputSlots + fuelSlots, tile);
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        this.fuelSlots = fuelSlots;
        this.inputHandler = inputSlots > 0 ? new RangedWrapper((IItemHandlerModifiable)this, 0, inputSlots) : (IItemHandlerModifiable)EmptyHandler.INSTANCE;
        this.outputHandler = outputSlots > 0 ? new RangedWrapper((IItemHandlerModifiable)this, inputSlots, inputSlots + outputSlots) : (IItemHandlerModifiable)EmptyHandler.INSTANCE;
        this.fuelHandler = fuelSlots > 0 ? new RangedWrapper((IItemHandlerModifiable)this, inputSlots + outputSlots, inputSlots + outputSlots + fuelSlots) : (IItemHandlerModifiable)EmptyHandler.INSTANCE;
    }

    public IItemHandlerModifiable getInputHandler() {
        return this.inputHandler;
    }

    public IItemHandlerModifiable getOutputHandler() {
        return this.outputHandler;
    }

    public IItemHandlerModifiable getFuelHandler() {
        return this.fuelHandler;
    }

    private boolean isOutputSlot(int index) {
        return index >= this.inputSlots && index < this.inputSlots + this.outputSlots;
    }

    private NonNullList<ItemStack> getRange(int from, int to) {
        NonNullList list = NonNullList.func_191196_a();
        for (int i = from; i <= to; ++i) {
            if (this.getStackInSlot(i).func_190926_b()) continue;
            list.add((Object)this.getStackInSlot(i));
        }
        return list;
    }

    public NonNullList<ItemStack> getInputStacks() {
        return this.getRange(0, this.inputSlots - 1);
    }

    public NonNullList<ItemStack> getFuelStacks() {
        return this.getRange(this.inputSlots + this.outputSlots, this.inputSlots + this.outputSlots + this.fuelSlots - 1);
    }

    public ItemStack insertOutput(int outputSlot, ItemStack stack, boolean simulate) {
        return super.insertItem(this.inputSlots + outputSlot, stack, simulate);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.isOutputSlot(slot)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    public void removeInputsFromInput(List<RecipeInput> inputs) {
        ItemHelper.removeInputsFromInventory(inputs, (IItemHandlerModifiable)this, 0, this.inputSlots);
    }

    public void removeInputsFromFuel(List<RecipeInput> inputs) {
        ItemHelper.removeInputsFromInventory(inputs, (IItemHandlerModifiable)this, this.inputSlots + this.outputSlots, this.fuelSlots);
    }
}

