/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;

public class IOHelper {
    @Nullable
    public static String readStringFromModFile(File modDirectoryOrZip, String path) {
        if (modDirectoryOrZip.isDirectory()) {
            return IOHelper.readStringFromFile(modDirectoryOrZip, path);
        }
        return IOHelper.readStringFromZip(modDirectoryOrZip, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readStringFromFile(File modDirectory, String path) {
        String result = null;
        FileInputStream stream = null;
        try {
            File file = new File(modDirectory, path);
            stream = new FileInputStream(file);
            result = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            if (stream == null) return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return result;
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly(stream);
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStringFromZip(File modZip, String path) {
        ZipFile zip = null;
        String result = null;
        try {
            zip = new ZipFile(modZip);
            ZipEntry entry = zip.getEntry(path);
            if (entry != null) {
                InputStream stream = zip.getInputStream(entry);
                result = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (zip != null) {
                IOUtils.closeQuietly((Closeable)zip);
            }
        }
        return result;
    }
}

