/*
 * Decompiled with CFR 0.152.
 */
package de.randombyte.lottery.commands;

import de.randombyte.lottery.Config;
import de.randombyte.lottery.InternalData;
import de.randombyte.lottery.LotteryKt;
import de.randombyte.lottery.shaded.kosp.config.ConfigManager;
import de.randombyte.lottery.shaded.kosp.extensions.StringsKt;
import de.randombyte.lottery.shaded.kosp.extensions.TextsKt;
import de.randombyte.lottery.shaded.kotlin.Metadata;
import de.randombyte.lottery.shaded.kotlin.jvm.internal.Intrinsics;
import java.math.BigDecimal;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.text.Text;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lde/randombyte/lottery/commands/AddPotCommand;", "Lorg/spongepowered/api/command/spec/CommandExecutor;", "configManager", "Lde/randombyte/lottery/shaded/kosp/config/ConfigManager;", "Lde/randombyte/lottery/Config;", "transactionCause", "Lorg/spongepowered/api/event/cause/Cause;", "(Lde/randombyte/kosp/config/ConfigManager;Lorg/spongepowered/api/event/cause/Cause;)V", "getConfigManager", "()Lde/randombyte/kosp/config/ConfigManager;", "getTransactionCause", "()Lorg/spongepowered/api/event/cause/Cause;", "execute", "Lorg/spongepowered/api/command/CommandResult;", "src", "Lorg/spongepowered/api/command/CommandSource;", "args", "Lorg/spongepowered/api/command/args/CommandContext;", "lottery"})
public final class AddPotCommand
implements CommandExecutor {
    @NotNull
    private final ConfigManager<Config> configManager;
    @NotNull
    private final Cause transactionCause;

    @NotNull
    public CommandResult execute(@NotNull CommandSource src, @NotNull CommandContext args) {
        Text amountText;
        Intrinsics.checkParameterIsNotNull(src, "src");
        Intrinsics.checkParameterIsNotNull(args, "args");
        Config config = this.configManager.get();
        Integer amount = (Integer)args.getOne("amount").get();
        int maxDeposit = config.getMaxDeposit();
        if (Intrinsics.compare(amount, 1) < 0) {
            throw (Throwable)new CommandException(StringsKt.toText("'amount' has to be a value above zero!"));
        }
        if (Intrinsics.compare(amount, maxDeposit) > 0) {
            throw (Throwable)new CommandException(StringsKt.toText("You're not allowed to deposit amounts above " + maxDeposit + '!'));
        }
        EconomyService economyService = LotteryKt.getEconomyServiceOrFail();
        if (src instanceof Player) {
            TransactionResult transactionResult;
            UniqueAccount uniqueAccount = (UniqueAccount)economyService.getOrCreateAccount(((Player)src).getUniqueId()).get();
            Currency currency = economyService.getDefaultCurrency();
            Integer n = amount;
            Intrinsics.checkExpressionValueIsNotNull(n, "amount");
            TransactionResult transactionResult2 = transactionResult = uniqueAccount.withdraw(currency, new BigDecimal(n), this.transactionCause);
            Intrinsics.checkExpressionValueIsNotNull(transactionResult2, "transactionResult");
            if (Intrinsics.areEqual(transactionResult2.getResult(), ResultType.SUCCESS) ^ true) {
                throw (Throwable)new CommandException(config.getMessages().getNotEnoughMoney());
            }
        }
        InternalData internalData = config.getInternalData();
        int n = config.getInternalData().getPot();
        Integer n2 = amount;
        Intrinsics.checkExpressionValueIsNotNull(n2, "amount");
        Config newConfig = Config.copy$default(config, null, 0, 0, 0, 0, null, InternalData.copy$default(internalData, null, n + n2, 1, null), null, 191, null);
        this.configManager.save(newConfig);
        Text text = amountText = economyService.getDefaultCurrency().format(new BigDecimal(amount));
        Intrinsics.checkExpressionValueIsNotNull(text, "amountText");
        src.sendMessage(TextsKt.plus(text, StringsKt.green(" has been added to the pot.")));
        CommandResult commandResult = CommandResult.success();
        Intrinsics.checkExpressionValueIsNotNull(commandResult, "CommandResult.success()");
        return commandResult;
    }

    @NotNull
    public final ConfigManager<Config> getConfigManager() {
        return this.configManager;
    }

    @NotNull
    public final Cause getTransactionCause() {
        return this.transactionCause;
    }

    public AddPotCommand(@NotNull ConfigManager<Config> configManager, @NotNull Cause transactionCause) {
        Intrinsics.checkParameterIsNotNull(configManager, "configManager");
        Intrinsics.checkParameterIsNotNull(transactionCause, "transactionCause");
        this.configManager = configManager;
        this.transactionCause = transactionCause;
    }
}

