/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.client.util.RenderUtils;
import tonius.simplyjetpacks.config.ConfigWrapper;
import tonius.simplyjetpacks.config.Defaults;
import tonius.simplyjetpacks.config.Section;
import tonius.simplyjetpacks.item.Fluxpack;
import tonius.simplyjetpacks.item.Jetpack;

public class Config {
    public static final List<Section> configSections = new ArrayList<Section>();
    private static final Section sectionItems = new Section(false, "items");
    private static final Section sectionIntegration = new Section(false, "integration");
    private static final Section sectionTuning = new Section(false, "tuning");
    private static final Section sectionControls = new Section(true, "controls");
    private static final Section sectionAesthetics = new Section(true, "aesthetics");
    private static final Section sectionSounds = new Section(true, "sounds");
    private static final Section sectionGui = new Section(true, "gui");
    public static ConfigWrapper configCommon;
    public static ConfigWrapper configClient;
    public static boolean enableFuelEfficiencyEnchantment;
    public static boolean addRAItemsIfNotInstalled;
    public static boolean enableIntegrationVanilla;
    public static boolean enableIntegrationEIO;
    public static boolean enableIntegrationTE;
    public static boolean enableIntegrationTD;
    public static boolean enableIntegrationRA;
    public static boolean enableIntegrationMek;
    public static boolean enableIntegrationIE;
    public static boolean enableIntegrationRR;
    public static float gelidEnderiumEnergyUsageBonus;
    public static boolean customControls;
    public static String flyKey;
    public static String descendKey;
    public static boolean invertHoverSneakingBehavior;
    public static boolean doubleTapSprintInAir;
    public static boolean enableArmor3DModels;
    public static boolean jetpackSounds;
    public static boolean holdShiftForDetails;
    public static RenderUtils.HUDPositions HUDPosition;
    public static int HUDTextColor;
    public static int HUDOffsetX;
    public static int HUDOffsetY;
    public static double HUDScale;
    public static boolean showHUDWhileChatting;
    public static boolean enableEnergyHUD;
    public static boolean minimalEnergyHUD;
    public static boolean showExactEnergyInHUD;
    public static boolean enableStateHUD;
    public static boolean enableStateMessages;

    public static void preInit(FMLPreInitializationEvent event) {
        configCommon = new ConfigWrapper(new File(event.getModConfigurationDirectory(), "simplyjetpacks/common.cfg"), "1.12.2-2.2.16.1", true);
        configClient = new ConfigWrapper(new File(event.getModConfigurationDirectory(), "simplyjetpacks/client.cfg"), "1.12.2-2.2.16.1", true);
        Config.syncConfig();
        SimplyJetpacks.proxy.updateCustomKeybinds(flyKey, descendKey);
    }

    public static void processConfig() {
        enableFuelEfficiencyEnchantment = configCommon.getBooleanS(Config.sectionItems.category, "enableFuelEfficiencyEnchantment", null, true, true);
        addRAItemsIfNotInstalled = configCommon.getBooleanS(Config.sectionItems.category, "addRAItemsIfNotInstalled", null, true, true);
        enableIntegrationVanilla = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationVanilla", null, true, true);
        enableIntegrationEIO = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationEIO", null, Defaults.enableIntegrationEIO, true);
        enableIntegrationTE = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationTE", null, Defaults.enableIntegrationTE, true);
        enableIntegrationTD = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationTD", null, Defaults.enableIntegrationTD, true);
        enableIntegrationRA = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationRA", null, Defaults.enableIntegrationRA, true);
        enableIntegrationMek = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationMek", null, Defaults.enableIntegrationMek, true);
        enableIntegrationIE = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationIE", null, Defaults.enableIntegrationIE, true);
        enableIntegrationRR = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationRR", null, Defaults.enableIntegrationRR, true);
        gelidEnderiumEnergyUsageBonus = configCommon.getIntS(Config.sectionIntegration.category, "gelidEnderiumEnergyUsageBonus", null, 80, 0, 100, true);
        customControls = configClient.getBooleanS(Config.sectionControls.category, "customControls", null, false, false);
        flyKey = configClient.getStringS(Config.sectionControls.category, "flyKey", null, "SPACE", false);
        descendKey = configClient.getStringS(Config.sectionControls.category, "descendKey", null, "LSHIFT", false);
        customControls = configClient.getBooleanS(Config.sectionControls.category, "customControls", null, false, false);
        invertHoverSneakingBehavior = configClient.getBooleanS(Config.sectionControls.category, "invertHoverSneakingBehavior", null, false, false);
        doubleTapSprintInAir = configClient.getBooleanS(Config.sectionControls.category, "doubleTapSprintInAir", null, true, false);
        enableArmor3DModels = configClient.getBooleanS(Config.sectionAesthetics.category, "enableArmor3DModels", null, true, false);
        jetpackSounds = configClient.getBooleanS(Config.sectionSounds.category, "jetpackSounds", null, true, false);
        holdShiftForDetails = configClient.getBooleanS(Config.sectionGui.category, "holdShiftForDetails", null, true, false);
        HUDPosition = RenderUtils.HUDPositions.valueOf(configClient.getStringListS(Config.sectionGui.category, "hudPosition", null, Defaults.HUDPosition.name(), new String[]{"TOP_LEFT", "TOP_CENTER", "TOP_RIGHT", "LEFT", "RIGHT", "BOTTOM_LEFT", "BOTTOM_RIGHT"}, false));
        HUDOffsetX = configClient.getIntS(Config.sectionGui.category, "HUDOffsetX", null, 0, null, null, false);
        HUDOffsetY = configClient.getIntS(Config.sectionGui.category, "HUDOffsetY", null, 0, null, null, false);
        HUDScale = configClient.getDoubleS(Config.sectionGui.category, "HUDScale", null, 1.0, 0.001, null, false);
        showHUDWhileChatting = configClient.getBooleanS(Config.sectionGui.category, "showHUDWhileChatting", null, true, false);
        enableEnergyHUD = configClient.getBooleanS(Config.sectionGui.category, "enableEnergyHUD", null, true, false);
        minimalEnergyHUD = configClient.getBooleanS(Config.sectionGui.category, "minimalEnergyHUD", null, false, false);
        showExactEnergyInHUD = configClient.getBooleanS(Config.sectionGui.category, "showExactEnergyInHUD", null, false, false);
        enableStateHUD = configClient.getBooleanS(Config.sectionGui.category, "enableStateHUD", null, true, false);
        enableStateMessages = configClient.getBooleanS(Config.sectionGui.category, "enableStateMessages", null, true, false);
        HUDTextColor = configClient.getIntS(Config.sectionGui.category, "HUDTextColor", null, 0xEEEEEE, Integer.MIN_VALUE, Integer.MAX_VALUE, false);
        Jetpack.loadAllConfigs(configCommon);
        Fluxpack.loadAllConfigs(configCommon);
    }

    private static void syncConfig() {
        SimplyJetpacks.logger.info("Loading Configuration Files...");
        try {
            Config.processConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (configCommon.hasChanged()) {
                configCommon.save();
            }
            if (configClient.hasChanged()) {
                configClient.save();
            }
        }
    }

    public static void onConfigChanged() {
        SimplyJetpacks.logger.info("Simply Jetpacks Config Changed!");
        Config.syncConfig();
        SimplyJetpacks.proxy.updateCustomKeybinds(flyKey, descendKey);
    }

    static {
        enableFuelEfficiencyEnchantment = true;
        addRAItemsIfNotInstalled = true;
        enableIntegrationVanilla = true;
        enableIntegrationEIO = Defaults.enableIntegrationEIO;
        enableIntegrationTE = Defaults.enableIntegrationTE;
        enableIntegrationTD = Defaults.enableIntegrationTD;
        enableIntegrationRA = Defaults.enableIntegrationRA;
        enableIntegrationMek = Defaults.enableIntegrationMek;
        enableIntegrationIE = Defaults.enableIntegrationIE;
        enableIntegrationRR = Defaults.enableIntegrationRR;
        gelidEnderiumEnergyUsageBonus = 80.0f;
        customControls = false;
        flyKey = "SPACE";
        descendKey = "LSHIFT";
        invertHoverSneakingBehavior = false;
        doubleTapSprintInAir = true;
        enableArmor3DModels = true;
        jetpackSounds = true;
        holdShiftForDetails = true;
        HUDPosition = Defaults.HUDPosition;
        HUDTextColor = 0xEEEEEE;
        HUDOffsetX = 0;
        HUDOffsetY = 0;
        HUDScale = 1.0;
        showHUDWhileChatting = true;
        enableEnergyHUD = true;
        minimalEnergyHUD = false;
        showExactEnergyInHUD = false;
        enableStateHUD = true;
        enableStateMessages = true;
    }
}

