/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tickcentral.asm;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ParameterNode;

public class Utilities {
    public static MethodNode CopyMethodAppearance(MethodNode node) {
        MethodNode newNode = new MethodNode();
        newNode.access = node.access;
        newNode.name = node.name;
        newNode.desc = node.desc;
        newNode.signature = node.signature;
        newNode.parameters = node.parameters == null ? null : Utilities.CopyParameterNodes(node.parameters);
        newNode.exceptions = new LinkedList(node.exceptions);
        newNode.attrs = node.attrs == null ? null : new LinkedList(node.attrs);
        return newNode;
    }

    @Nonnull
    public static List<ParameterNode> CopyParameterNodes(@Nonnull List<ParameterNode> nodes) {
        LinkedList<ParameterNode> list = new LinkedList<ParameterNode>();
        for (ParameterNode node : nodes) {
            list.add(Utilities.CopyParameterNode(node));
        }
        return list;
    }

    public static ParameterNode CopyParameterNode(ParameterNode node) {
        return new ParameterNode(node.name, node.access);
    }

    public static void convertAllInstructions(String newTarget, InsnList instructions) {
        for (AbstractInsnNode node : instructions) {
            switch (node.getOpcode()) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    MethodInsnNode methodNode = (MethodInsnNode)node;
                    methodNode.name = newTarget;
                }
            }
        }
    }

    public static boolean convertTargetInstruction(String targetOwner, String targetName, String targetDesc, String newOwner, String newName, InsnList instructions) {
        ListIterator iterator = instructions.iterator();
        boolean dirty = false;
        while (iterator.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)iterator.next();
            switch (node.getOpcode()) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    MethodInsnNode methodNode = (MethodInsnNode)node;
                    if (!methodNode.owner.equals(targetOwner) || !methodNode.name.equals(targetName) || !methodNode.desc.equals(targetDesc)) break;
                    methodNode.name = newName;
                    methodNode.owner = newOwner;
                    dirty = true;
                }
            }
        }
        return dirty;
    }

    public static boolean convertSuperInstructions(String targetName, String targetDesc, String newName, InsnList instructions) {
        ListIterator iterator = instructions.iterator();
        boolean dirty = false;
        while (iterator.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)iterator.next();
            if (node.getOpcode() != 183) continue;
            MethodInsnNode methodNode = (MethodInsnNode)node;
            if (!methodNode.name.equals(targetName) || !methodNode.desc.equals(targetDesc)) continue;
            methodNode.name = newName;
            dirty = true;
        }
        return dirty;
    }

    public static boolean usesMethodInstruction(int opcode, String targetOwner, String targetName, String targetDesc, InsnList instructions) {
        for (AbstractInsnNode node : instructions) {
            if (node.getOpcode() != opcode) continue;
            MethodInsnNode methodNode = (MethodInsnNode)node;
            if (!methodNode.owner.equals(targetOwner) || !methodNode.name.equals(targetName) || !methodNode.desc.equals(targetDesc)) continue;
            return true;
        }
        return false;
    }

    public static boolean usesConstant(InsnList instructions, Object constant) {
        for (AbstractInsnNode node : instructions) {
            if (node.getOpcode() != 18) continue;
            LdcInsnNode ldc = (LdcInsnNode)node;
            if (ldc.cst != constant && !constant.equals(ldc.cst)) continue;
            return true;
        }
        return false;
    }
}

