/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.api.service;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.api.nucleusdata.MailMessage;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.entity.living.player.User;

public interface NucleusMailService {
    public List<MailMessage> getMail(User var1, MailFilter ... var2);

    public boolean removeMail(User var1, MailMessage var2);

    public void sendMail(User var1, User var2, String var3);

    public void sendMailFromConsole(User var1, String var2);

    public boolean clearUserMail(User var1);

    default public MailFilter createSenderFilter(boolean includeConsole, UUID ... player) {
        return this.createSenderFilter(includeConsole, Arrays.asList(player));
    }

    default public MailFilter createSenderFilter(boolean includeConsole, Collection<UUID> player) {
        return m -> m.getSender().map(x -> player.contains(x.getUniqueId())).orElse(includeConsole);
    }

    default public MailFilter createDateFilter(@Nullable Instant after, @Nullable Instant before) {
        Preconditions.checkArgument((after != null || before != null ? 1 : 0) != 0);
        Instant inAfter = after == null ? Instant.ofEpochMilli(0L) : after;
        Instant inBefore = before == null ? Instant.now() : before;
        return m -> inAfter.isBefore(m.getDate()) && inBefore.isAfter(m.getDate());
    }

    default public MailFilter createMessageFilter(boolean caseSensitive, String ... message) {
        return this.createMessageFilter(caseSensitive, Arrays.asList(message));
    }

    default public MailFilter createMessageFilter(boolean caseSensitive, Collection<String> message) {
        List strings = message.stream().map(x -> !caseSensitive ? x.toLowerCase() : x).collect(Collectors.toList());
        return m -> {
            String mm = caseSensitive ? m.getMessage() : m.getMessage().toLowerCase();
            return strings.stream().allMatch(mm::contains);
        };
    }

    @FunctionalInterface
    public static interface MailFilter
    extends Predicate<MailMessage> {
    }
}

