/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal;

import com.google.common.collect.ImmutableMap;
import io.github.nucleuspowered.nucleus.Nucleus;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;

public final class DataScanner {
    private static DataScanner instance = null;
    private static final NumberFormat nf = new DecimalFormat("0.000");
    private final Map<String, Key<? extends BaseValue<?>>> reportableKeys = new HashMap();

    public static DataScanner getInstance() {
        if (instance == null) {
            instance = new DataScanner();
        }
        return instance;
    }

    private DataScanner() {
        Field[] f;
        for (Field fi : f = Keys.class.getFields()) {
            try {
                Object o = fi.get(null);
                if (!(o instanceof Key)) continue;
                this.reportableKeys.put(this.createName(fi.getName()), (Key)o);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private String createName(String name) {
        String[] n = name.split("_");
        for (int i = 0; i < n.length; ++i) {
            n[i] = n[i].substring(0, 1).toUpperCase() + n[i].substring(1).toLowerCase();
        }
        return String.join((CharSequence)" ", n);
    }

    public ImmutableMap<String, Key<? extends BaseValue<?>>> getKeysForHolder(DataHolder holder) {
        try {
            Set siv = holder.getValues();
            Map<String, Key> m = siv.stream().collect(Collectors.toMap(x -> {
                List ld = x.getKey().getQuery().getParts();
                return (String)ld.get(ld.size() - 1);
            }, BaseValue::getKey));
            return ImmutableMap.copyOf(m);
        }
        catch (AbstractMethodError e) {
            return this.getKeys();
        }
    }

    private ImmutableMap<String, Key<? extends BaseValue<?>>> getKeys() {
        return ImmutableMap.copyOf(this.reportableKeys);
    }

    public static Optional<Text> getText(CommandSource src, String translationKey, String key, Object x) {
        Class<?> c;
        String v = String.valueOf(x);
        if (!v.equals(String.format("%s@%s", (c = x.getClass()).getName(), Integer.toHexString(x.hashCode())))) {
            if (x instanceof Double || x instanceof Float || x instanceof BigDecimal) {
                return Optional.of(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat(translationKey, key, nf.format(x)));
            }
            if (x instanceof Text) {
                return Optional.of(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat(translationKey, key, TextSerializers.FORMATTING_CODE.serialize((Text)x)));
            }
            return Optional.of(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat(translationKey, key, v));
        }
        return Optional.empty();
    }
}

