/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.teleport;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableList;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.core.config.SafeTeleportConfig;
import io.github.nucleuspowered.nucleus.modules.teleport.events.AboutToTeleportEvent;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.property.AbstractProperty;
import org.spongepowered.api.data.property.block.PassableProperty;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.TeleportHelper;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.api.world.teleport.TeleportHelperFilters;

public class NucleusTeleportHandler {
    public static final TeleportHelper TELEPORT_HELPER = Sponge.getGame().getTeleportHelper();
    private static final List<BlockType> unsafeBody = ImmutableList.of((Object)BlockTypes.AIR, (Object)BlockTypes.CACTUS, (Object)BlockTypes.FIRE, (Object)BlockTypes.LAVA, (Object)BlockTypes.FLOWING_LAVA);

    public final StandardTeleportMode getTeleportModeForPlayer(Player pl) {
        GameMode gm = pl.getGameModeData().get(Keys.GAME_MODE).orElse(GameModes.SURVIVAL);
        if (gm == GameModes.CREATIVE) {
            return StandardTeleportMode.WALL_CHECK;
        }
        if (gm == GameModes.SPECTATOR) {
            return StandardTeleportMode.NO_CHECK;
        }
        return StandardTeleportMode.FLYING_THEN_SAFE;
    }

    public TeleportResult teleportPlayer(Player player, Location<World> locationToTeleportTo, boolean safe) {
        return this.teleportPlayer(player, locationToTeleportTo, player.getRotation(), safe);
    }

    public TeleportResult teleportPlayer(Player player, Location<World> worldLocation, Vector3d rotation, boolean safe) {
        StandardTeleportMode mode = safe ? this.getTeleportModeForPlayer(player) : StandardTeleportMode.NO_CHECK;
        return CauseStackHelper.createFrameWithCausesWithReturn(c -> this.teleportPlayer(player, worldLocation, rotation, mode, (Cause)c, true), player);
    }

    public TeleportResult teleportPlayer(Player player, Transform<World> worldTransform) {
        return CauseStackHelper.createFrameWithCausesWithReturn(c -> this.teleportPlayer(player, (Location<World>)worldTransform.getLocation(), worldTransform.getRotation(), this.getTeleportModeForPlayer(player), (Cause)c, true), player);
    }

    public TeleportResult teleportPlayer(Player player, Transform<World> worldTransform, boolean safe, boolean borderCheck) {
        StandardTeleportMode mode = safe ? this.getTeleportModeForPlayer(player) : StandardTeleportMode.NO_CHECK;
        return CauseStackHelper.createFrameWithCausesWithReturn(c -> this.teleportPlayer(player, (Location<World>)worldTransform.getLocation(), worldTransform.getRotation(), mode, (Cause)c, borderCheck), player);
    }

    public TeleportResult teleportPlayer(Player player, Transform<World> locationToTeleportTo, StandardTeleportMode teleportMode) {
        return CauseStackHelper.createFrameWithCausesWithReturn(c -> this.teleportPlayer(player, (Location<World>)locationToTeleportTo.getLocation(), locationToTeleportTo.getRotation(), teleportMode, (Cause)c, true), player);
    }

    public TeleportResult teleportPlayer(Player player, Transform<World> locationToTeleportTo, StandardTeleportMode teleportMode, boolean borderCheck) {
        return CauseStackHelper.createFrameWithCausesWithReturn(c -> this.teleportPlayer(player, (Location<World>)locationToTeleportTo.getLocation(), locationToTeleportTo.getRotation(), teleportMode, (Cause)c, borderCheck), player);
    }

    public TeleportResult teleportPlayer(Player player, Transform<World> locationToTeleportTo, TeleportMode teleportMode, Cause cause) {
        return this.teleportPlayer(player, (Location<World>)locationToTeleportTo.getLocation(), locationToTeleportTo.getRotation(), teleportMode, cause, true);
    }

    public TeleportResult teleportPlayer(Player player, Transform<World> locationToTeleportTo, TeleportMode teleportMode, Cause cause, boolean borderCheck) {
        return this.teleportPlayer(player, (Location<World>)locationToTeleportTo.getLocation(), locationToTeleportTo.getRotation(), teleportMode, cause, borderCheck);
    }

    public TeleportResult teleportPlayer(Player pl, Location<World> loc, TeleportMode mode) {
        return CauseStackHelper.createFrameWithCausesWithReturn(c -> this.teleportPlayer(pl, loc, mode, (Cause)c), pl);
    }

    public TeleportResult teleportPlayer(Player pl, Location<World> loc, TeleportMode mode, Cause of) {
        return this.teleportPlayer(pl, loc, pl.getRotation(), mode, of, true);
    }

    public TeleportResult teleportPlayer(Player pl, Location<World> loc, TeleportMode mode, Cause of, boolean addOffset) {
        return this.teleportPlayer(pl, loc, pl.getRotation(), mode, of, addOffset, true);
    }

    public TeleportResult teleportPlayer(Player player, Location<World> locationToTeleportTo, Vector3d rotation, TeleportMode teleportMode, Cause cause, boolean borderCheck) {
        return this.teleportPlayer(player, locationToTeleportTo, rotation, teleportMode, cause, false, borderCheck);
    }

    public TeleportResult teleportPlayer(Player player, Location<World> locationToTeleportTo, Vector3d rotation, TeleportMode teleportMode, Cause cause, boolean addOffset, boolean borderCheck) {
        Optional<Location<World>> targetLocation = this.getSafeLocation(player, locationToTeleportTo, teleportMode);
        if (targetLocation.isPresent() && (!borderCheck || Util.isLocationInWorldBorder(targetLocation.get()))) {
            TeleportResult tr;
            AboutToTeleportEvent event = new AboutToTeleportEvent(cause, (Transform<World>)new Transform(targetLocation.get().getExtent(), targetLocation.get().getPosition(), rotation), player);
            if (Sponge.getEventManager().post((Event)event)) {
                event.getCancelMessage().ifPresent(x -> {
                    Object o = cause.root();
                    if (o instanceof MessageReceiver) {
                        ((MessageReceiver)o).sendMessage(x);
                    }
                });
                return TeleportResult.FAILED_CANCELLED;
            }
            Optional oe = player.getVehicle();
            if (oe.isPresent()) {
                player.setVehicle(null);
            }
            if ((tr = addOffset ? this.result(player.setLocationAndRotation(targetLocation.get().add(0.5, 0.5, 0.5), rotation)) : this.result(player.setLocationAndRotation(targetLocation.get(), rotation))).isSuccess()) {
                player.setSpectatorTarget(null);
            } else {
                oe.ifPresent(arg_0 -> ((Player)player).setVehicle(arg_0));
            }
            return tr;
        }
        return TeleportResult.FAILED_NO_LOCATION;
    }

    public Optional<Location<World>> getSafeLocation(@Nullable Player player, Location<World> locationToTeleportTo, TeleportMode teleportMode) {
        if (player == null && teleportMode == StandardTeleportMode.FLYING_THEN_SAFE) {
            teleportMode = StandardTeleportMode.SAFE_TELEPORT;
        }
        ((World)locationToTeleportTo.getExtent()).loadChunk(locationToTeleportTo.getChunkPosition(), true);
        return (Optional)teleportMode.apply(player, locationToTeleportTo);
    }

    private static boolean isPassable(Location<World> worldLocation, boolean checkSafe) {
        BlockState block = worldLocation.getBlock();
        if (checkSafe && unsafeBody.contains(block.getType())) {
            return false;
        }
        return block.getProperty(PassableProperty.class).map(x -> (Boolean)x.getValue()).orElse(false);
    }

    public static boolean setLocation(Player player, Location<World> location) {
        if (player.setLocation(location)) {
            player.setSpectatorTarget(null);
            return true;
        }
        return false;
    }

    private TeleportResult result(boolean res) {
        return res ? TeleportResult.SUCCESS : TeleportResult.FAILED_CANCELLED;
    }

    public static enum TeleportResult {
        SUCCESS(true),
        FAILED_NO_LOCATION(false),
        FAILED_CANCELLED(false);

        private final boolean b;

        private TeleportResult(boolean b) {
            this.b = b;
        }

        public boolean isSuccess() {
            return this.b;
        }
    }

    public static enum StandardTeleportMode implements TeleportMode
    {
        NO_CHECK{

            @Override
            public Optional<Location<World>> apply(Player player, Location<World> location) {
                return Optional.of(location);
            }
        }
        ,
        FLYING_THEN_SAFE{

            @Override
            public Optional<Location<World>> apply(Player player, Location<World> location) {
                if (player.get(Keys.IS_FLYING).orElse(false).booleanValue()) {
                    return Sponge.getTeleportHelper().getSafeLocationWithBlacklist(location, 3, 9, 2, new TeleportHelperFilter[]{TeleportHelperFilters.FLYING});
                }
                return (Optional)SAFE_TELEPORT.apply(player, location);
            }
        }
        ,
        FLYING_THEN_SAFE_CHUNK{

            @Override
            public Optional<Location<World>> apply(Player player, Location<World> location) {
                if (player.get(Keys.IS_FLYING).orElse(false).booleanValue()) {
                    return Sponge.getTeleportHelper().getSafeLocationWithBlacklist(location, 8, 8, 2, new TeleportHelperFilter[]{TeleportHelperFilters.FLYING});
                }
                return (Optional)SAFE_TELEPORT_CHUNK.apply(player, location);
            }
        }
        ,
        WALL_CHECK{

            @Override
            public Optional<Location<World>> apply(Player player, Location<World> location) {
                if (NucleusTeleportHandler.isPassable((Location<World>)location, false) && NucleusTeleportHandler.isPassable((Location<World>)location.add(0.0, 1.0, 0.0), false)) {
                    return Optional.of(location);
                }
                return (Optional)SAFE_TELEPORT.apply(player, location);
            }
        }
        ,
        WALL_CHECK_ASCENDING{

            @Override
            public Optional<Location<World>> apply(Player player, Location<World> location) {
                Location locationToCheck = 5.setValidY(location);
                int y = ((World)location.getExtent()).getBlockMax().getY() - 1;
                while (locationToCheck.getBlockY() < y) {
                    Optional olw = (Optional)WALL_CHECK.apply(player, locationToCheck);
                    if (olw.isPresent()) {
                        return olw;
                    }
                    locationToCheck = locationToCheck.add(0.0, 1.0, 0.0);
                }
                return Optional.empty();
            }
        }
        ,
        SAFE_TELEPORT{
            private CoreConfigAdapter coreConfigAdapter = null;

            @Override
            private CoreConfigAdapter getCoreConfigAdapter() throws Exception {
                if (this.coreConfigAdapter == null) {
                    this.coreConfigAdapter = Nucleus.getNucleus().getModuleContainer().getConfigAdapterForModule("core", CoreConfigAdapter.class);
                }
                return this.coreConfigAdapter;
            }

            @Override
            public Optional<Location<World>> apply(Player player, Location<World> location) {
                Location lw;
                SafeTeleportConfig stc;
                try {
                    stc = ((CoreConfig)this.getCoreConfigAdapter().getNodeOrDefault()).getSafeTeleportConfig();
                }
                catch (Exception e) {
                    stc = new SafeTeleportConfig();
                }
                Optional olw = TELEPORT_HELPER.getSafeLocation(6.setValidY(location), stc.getHeight(), stc.getWidth());
                if (olw.isPresent() && !((World)(lw = (Location)olw.get()).getExtent()).getBlock(lw.getBlockPosition()).getProperty(PassableProperty.class).map(AbstractProperty::getValue).orElse(true).booleanValue()) {
                    return Optional.of(lw.add(0.0, 1.0, 0.0));
                }
                return olw;
            }
        }
        ,
        FLYING_THEN_SAFE_TELEPORT_SURFACE{

            @Override
            public Optional<Location<World>> apply(Player player, Location<World> location) {
                if (player.get(Keys.IS_FLYING).orElse(false).booleanValue()) {
                    return Sponge.getTeleportHelper().getSafeLocationWithBlacklist(location, 3, 9, 2, new TeleportHelperFilter[]{TeleportHelperFilters.FLYING});
                }
                return (Optional)SAFE_TELEPORT_SURFACE.apply(player, 7.setValidY(location));
            }
        }
        ,
        SAFE_TELEPORT_SURFACE{
            private CoreConfigAdapter coreConfigAdapter = null;

            @Override
            private CoreConfigAdapter getCoreConfigAdapter() throws Exception {
                if (this.coreConfigAdapter == null) {
                    this.coreConfigAdapter = Nucleus.getNucleus().getModuleContainer().getConfigAdapterForModule("core", CoreConfigAdapter.class);
                }
                return this.coreConfigAdapter;
            }

            @Override
            public Optional<Location<World>> apply(Player player, Location<World> location) {
                SafeTeleportConfig stc;
                try {
                    stc = ((CoreConfig)this.getCoreConfigAdapter().getNodeOrDefault()).getSafeTeleportConfig();
                }
                catch (Exception e) {
                    stc = new SafeTeleportConfig();
                }
                return TELEPORT_HELPER.getSafeLocationWithBlacklist(8.setValidY(location), stc.getHeight(), stc.getWidth(), 2, new TeleportHelperFilter[]{TeleportHelperFilters.SURFACE_ONLY});
            }
        }
        ,
        SAFE_TELEPORT_CHUNK{

            @Override
            public Optional<Location<World>> apply(Player player, Location<World> location) {
                return TELEPORT_HELPER.getSafeLocation(9.setValidY(location), 8, 8);
            }
        }
        ,
        SAFE_TELEPORT_ASCENDING{

            @Override
            public Optional<Location<World>> apply(Player player, Location<World> location) {
                return StandardTeleportMode.teleportCheck(player, (Location<World>)location, (l, h) -> l.add(0.0, (double)h.intValue(), 0.0), i -> i < ((World)10.setValidY(location).getExtent()).getBlockMax().getY() - 1);
            }
        }
        ,
        SAFE_TELEPORT_DESCEND{

            @Override
            public Optional<Location<World>> apply(Player player, Location<World> location) {
                return StandardTeleportMode.teleportCheck(player, (Location<World>)11.setValidY(location), (l, h) -> l.sub(0.0, (double)h.intValue(), 0.0), i -> i > 1);
            }
        };

        private static CoreConfigAdapter coreConfigAdapter;

        private static CoreConfigAdapter getCoreConfigAdapter() throws Exception {
            if (coreConfigAdapter == null) {
                coreConfigAdapter = Nucleus.getNucleus().getModuleContainer().getConfigAdapterForModule("core", CoreConfigAdapter.class);
            }
            return coreConfigAdapter;
        }

        private static Optional<Location<World>> teleportCheck(Player player, Location<World> location, BiFunction<Location<World>, Integer, Location<World>> locationTransformFunction, Predicate<Integer> blockWhileLoop) {
            int height;
            Location<World> locationToCheck = StandardTeleportMode.setValidY(location);
            try {
                height = ((CoreConfig)StandardTeleportMode.getCoreConfigAdapter().getNodeOrDefault()).getSafeTeleportConfig().getHeight();
            }
            catch (Exception e) {
                height = 3;
            }
            while (blockWhileLoop.test(locationToCheck.getBlockY())) {
                Optional olw = (Optional)SAFE_TELEPORT.apply(player, locationToCheck);
                if (olw.isPresent()) {
                    return olw;
                }
                locationToCheck = locationTransformFunction.apply(locationToCheck, height);
            }
            return Optional.empty();
        }

        protected static Location<World> setValidY(Location<World> location) {
            int maxy = ((World)location.getExtent()).getBlockMax().getY();
            if (location.getBlockY() > maxy) {
                return new Location(location.getExtent(), location.getX(), (double)maxy, location.getZ());
            }
            return location;
        }

        static {
            coreConfigAdapter = null;
        }
    }

    public static interface TeleportMode
    extends BiFunction<Player, Location<World>, Optional<Location<World>>> {
    }
}

