/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.commandspy.listeners;

import com.google.common.collect.ImmutableSet;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.CommandPermissionHandler;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.text.TextParsingUtils;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.modules.commandspy.CommandSpyUserPrefKeys;
import io.github.nucleuspowered.nucleus.modules.commandspy.commands.CommandSpyCommand;
import io.github.nucleuspowered.nucleus.modules.commandspy.config.CommandSpyConfig;
import io.github.nucleuspowered.nucleus.modules.commandspy.config.CommandSpyConfigAdapter;
import io.github.nucleuspowered.nucleus.util.CommandNameCache;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.command.SendCommandEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;

public class CommandSpyListener
implements Reloadable,
ListenerBase.Conditional {
    private final String basePermission;
    private final String exemptTarget;
    private CommandSpyConfig config = new CommandSpyConfig();
    private Set<String> toSpy = ImmutableSet.of();
    private boolean listIsEmpty = true;
    private final UserPreferenceService userPreferenceService;

    public CommandSpyListener() {
        CommandPermissionHandler permissionHandler = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(CommandSpyCommand.class);
        this.basePermission = permissionHandler.getBase();
        this.exemptTarget = permissionHandler.getPermissionWithSuffix("exempt.target");
        this.userPreferenceService = this.getServiceUnchecked(UserPreferenceService.class);
    }

    @Listener(order=Order.LAST)
    public void onCommand(SendCommandEvent event, @Root Player player) {
        if (!this.hasPermission((Subject)player, this.exemptTarget)) {
            boolean isInList = false;
            if (!this.listIsEmpty) {
                String command = event.getCommand().toLowerCase();
                Set<String> cmd = CommandNameCache.INSTANCE.getFromCommandAndSource(command, (CommandSource)player);
                cmd.retainAll(this.toSpy);
                boolean bl = isInList = !cmd.isEmpty();
            }
            if (isInList == this.config.isUseWhitelist()) {
                UUID currentUUID = player.getUniqueId();
                List<Player> playerList = Sponge.getServer().getOnlinePlayers().stream().filter(x -> !x.getUniqueId().equals(currentUUID)).filter(x -> this.hasPermission((Subject)x, this.basePermission)).filter(x -> this.userPreferenceService.getUnwrapped(player.getUniqueId(), CommandSpyUserPrefKeys.COMMAND_SPY)).collect(Collectors.toList());
                if (!playerList.isEmpty()) {
                    Text prefix = this.config.getTemplate().getForCommandSource((CommandSource)player);
                    TextParsingUtils.StyleTuple st = TextParsingUtils.getLastColourAndStyle((TextRepresentable)prefix, null);
                    Text messageToSend = prefix.toBuilder().append(new Text[]{Text.of((Object[])new Object[]{st.colour, st.style, "/", event.getCommand(), Util.SPACE, event.getArguments()})}).build();
                    playerList.forEach(x -> x.sendMessage(messageToSend));
                }
            }
        }
    }

    @Override
    public void onReload() throws Exception {
        this.config = (CommandSpyConfig)Nucleus.getNucleus().getModuleContainer().getConfigAdapterForModule("command-spy", CommandSpyConfigAdapter.class).getNodeOrDefault();
        this.listIsEmpty = this.config.getCommands().isEmpty();
        this.toSpy = (Set)this.config.getCommands().stream().map(String::toLowerCase).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public boolean shouldEnable() {
        return !this.config.isUseWhitelist() || !this.listIsEmpty;
    }
}

