/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.argumentparsers.RegexArgument;
import io.github.nucleuspowered.nucleus.argumentparsers.UUIDArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.core.commands.NucleusCommand;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NoModifiers
@NonnullByDefault
@Permissions(prefix="nucleus", suggestedLevel=SuggestedLevel.NONE)
@RegisterCommand(value={"getuser"}, subcommandOf=NucleusCommand.class)
public class GetUserCommand
extends AbstractCommand<CommandSource> {
    private final String uuidKey = "UUID";
    private final String playerKey = "name";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{new UUIDArgument((Text)Text.of((String)this.uuidKey), Optional::ofNullable), new RegexArgument((Text)Text.of((String)this.playerKey), "^[A-Za-z0-9_]{3,16}$", "command.nucleus.getuser.regex")})};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        CompletableFuture profile;
        String toGet;
        GameProfileManager manager = Sponge.getServer().getGameProfileManager();
        if (args.hasAny(this.uuidKey)) {
            UUID u = (UUID)args.getOne(this.uuidKey).get();
            toGet = u.toString();
            profile = manager.get(u, false);
        } else {
            toGet = (String)args.getOne(this.playerKey).get();
            profile = manager.get(toGet, false);
        }
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.getuser.starting", toGet));
        profile.handle((gp, th) -> {
            if (th != null || gp == null) {
                if (th != null && Nucleus.getNucleus().isDebugMode()) {
                    th.printStackTrace();
                }
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.getuser.failed", toGet));
                return 0;
            }
            ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).getOrCreate(gp);
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.getuser.success", gp.getUniqueId().toString(), gp.getName().orElse("unknown")));
            return 0;
        });
        return CommandResult.success();
    }
}

