/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.home.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.exceptions.NucleusException;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Home;
import io.github.nucleuspowered.nucleus.api.service.NucleusHomeService;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.home.commands.HomeCommand;
import io.github.nucleuspowered.nucleus.modules.home.config.HomeConfig;
import io.github.nucleuspowered.nucleus.modules.home.config.HomeConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.home.services.HomeHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Permissions(prefix="home", mainOverride="set", suggestedLevel=SuggestedLevel.USER)
@RegisterCommand(value={"set"}, subcommandOf=HomeCommand.class, rootAliasRegister={"homeset", "sethome"})
@EssentialsEquivalent(value={"sethome", "createhome"})
@NonnullByDefault
public class SetHomeCommand
extends AbstractCommand<Player>
implements Reloadable {
    private final String homeKey = "home";
    private final HomeHandler homeHandler = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(HomeHandler.class);
    private boolean preventOverhang = true;

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"o", "-overwrite"}).buildWith(GenericArguments.onlyOne((CommandElement)GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"home")))))};
    }

    @Override
    public void onReload() throws Exception {
        this.preventOverhang = ((HomeConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(HomeConfigAdapter.class).getNodeOrDefault()).isPreventHomeCountOverhang();
    }

    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("unlimited", PermissionInformation.getWithTranslation("permission.homes.unlimited", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        boolean overwrite;
        String home = args.getOne("home").orElse("home").toLowerCase();
        if (!NucleusHomeService.HOME_NAME_PATTERN.matcher(home).matches()) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.sethome.name", new String[0]));
        }
        Optional<Home> currentHome = this.homeHandler.getHome((User)src, home);
        boolean bl = overwrite = currentHome.isPresent() && args.hasAny("o");
        if (currentHome.isPresent() && !overwrite) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.sethome.seterror", home));
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.sethome.tooverwrite", home).toBuilder().onClick((ClickAction)TextActions.runCommand((String)("/sethome " + home + " -o"))).build());
            return CommandResult.empty();
        }
        try {
            if (overwrite) {
                int max = this.homeHandler.getMaximumHomes((User)src);
                int c = this.homeHandler.getHomeCount((User)src);
                if (this.preventOverhang && max < c) {
                    throw ReturnMessageException.fromKey("command.sethome.overhang", String.valueOf(max), String.valueOf(c));
                }
                Home current = currentHome.get();
                this.homeHandler.modifyHomeInternal(cause, current, (Location<World>)src.getLocation(), src.getRotation());
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.sethome.overwrite", home));
            } else {
                this.homeHandler.createHomeInternal(cause, (User)src, home, (Location<World>)src.getLocation(), src.getRotation());
            }
        }
        catch (NucleusException e) {
            throw new ReturnMessageException(e.getText(), (Throwable)((Object)e));
        }
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.sethome.set", home));
        return CommandResult.success();
    }
}

