/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jump.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import io.github.nucleuspowered.nucleus.modules.jump.config.JumpConfig;
import io.github.nucleuspowered.nucleus.modules.jump.config.JumpConfigAdapter;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.data.property.block.PassableProperty;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Permissions
@RegisterCommand(value={"jump", "j", "jmp"})
@EssentialsEquivalent(value={"jump", "j", "jumpto"})
@NonnullByDefault
public class JumpCommand
extends AbstractCommand<Player>
implements Reloadable {
    private int maxJump = 20;

    @Override
    public CommandResult executeCommand(Player player, CommandContext args, Cause cause) throws Exception {
        BlockRay playerBlockRay = BlockRay.from((Entity)player).distanceLimit((double)this.maxJump).build();
        BlockRayHit finalHitRay = null;
        while (finalHitRay == null && playerBlockRay.hasNext()) {
            BlockRayHit currentHitRay = playerBlockRay.next();
            if (player.getWorld().getBlockType(currentHitRay.getBlockPosition()).equals(BlockTypes.AIR)) continue;
            finalHitRay = currentHitRay;
        }
        if (finalHitRay == null) {
            throw ReturnMessageException.fromKey("command.jump.noblock", new Object[0]);
        }
        Location finalLocation = finalHitRay.getLocation();
        Optional pp = finalHitRay.getLocation().getProperty(PassableProperty.class);
        if (pp.isPresent() && !this.getFromBoxed((Boolean)((PassableProperty)pp.get()).getValue())) {
            finalLocation = finalLocation.add(0.0, 1.0, 0.0);
        } else {
            Optional ppbelow = finalHitRay.getLocation().getRelative(Direction.DOWN).getProperty(PassableProperty.class);
            if (ppbelow.isPresent() && !this.getFromBoxed((Boolean)((PassableProperty)ppbelow.get()).getValue())) {
                finalLocation = finalLocation.sub(0.0, 1.0, 0.0);
            }
        }
        if (!Util.isLocationInWorldBorder((Location<World>)finalLocation)) {
            throw ReturnMessageException.fromKey("command.jump.outsideborder", new Object[0]);
        }
        if (Nucleus.getNucleus().getTeleportHandler().teleportPlayer(player, (Location<World>)finalLocation, (NucleusTeleportHandler.TeleportMode)NucleusTeleportHandler.StandardTeleportMode.SAFE_TELEPORT).isSuccess()) {
            player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.jump.success", new String[0]));
            return CommandResult.success();
        }
        throw ReturnMessageException.fromKey("command.jump.notsafe", new Object[0]);
    }

    private boolean getFromBoxed(@Nullable Boolean bool) {
        return bool != null ? bool : false;
    }

    @Override
    public void onReload() {
        this.maxJump = ((JumpConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(JumpConfigAdapter.class).getNodeOrDefault()).getMaxJump();
    }
}

