/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.argumentparsers.UUIDArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.mute.data.MuteData;
import io.github.nucleuspowered.nucleus.modules.mute.services.MuteHandler;
import java.time.Instant;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(suggestedLevel=SuggestedLevel.MOD)
@RunAsync
@NoModifiers
@RegisterCommand(value={"checkmute"})
@NonnullByDefault
public class CheckMuteCommand
extends AbstractCommand<CommandSource> {
    private final MuteHandler handler = (MuteHandler)this.getServiceUnchecked(MuteHandler.class);
    private final String playerKey = "user/UUID";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.user((Text)Text.of((String)this.playerKey)), new UUIDArgument((Text)Text.of((String)this.playerKey), u -> ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(u))})};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        User user = (User)args.getOne(this.playerKey).get();
        Optional<MuteData> omd = this.handler.getPlayerMuteData(user);
        if (!omd.isPresent()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkmute.none", user.getName()));
            return CommandResult.success();
        }
        MuteData md = omd.get();
        String name = !md.getMuter().isPresent() ? Sponge.getServer().getConsole().getName() : ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(md.getMuter().get()).map(User::getName).orElseGet(() -> Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.unknown", new String[0]));
        if (md.getRemainingTime().isPresent()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkmute.mutedfor", user.getName(), name, Util.getTimeStringFromSeconds(md.getRemainingTime().get().getSeconds())));
        } else {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkmute.mutedperm", user.getName(), name));
        }
        if (md.getCreationTime() > 0L) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkmute.created", Util.FULL_TIME_FORMATTER.withLocale(src.getLocale()).format(Instant.ofEpochSecond(md.getCreationTime()))));
        } else {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkmute.created", Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.unknown", new String[0])));
        }
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("standard.reasoncoloured", md.getReason()));
        return CommandResult.success();
    }
}

