/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.serverlist.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.argumentparsers.BoundedIntegerArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.modules.serverlist.commands.ServerListCommand;
import io.github.nucleuspowered.nucleus.modules.serverlist.datamodules.ServerListGeneralDataModule;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(prefix="serverlist")
@RunAsync
@RegisterCommand(value={"message", "m"}, subcommandOf=ServerListCommand.class)
@NonnullByDefault
public class TemporaryMessageCommand
extends AbstractCommand<CommandSource> {
    private final String line = "line";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"r", "-remove"}).valueFlag((CommandElement)new BoundedIntegerArgument((Text)Text.of((String)this.line), 1, 2), new String[]{"l", "-line"}).valueFlag(NucleusParameters.DURATION, new String[]{"t", "-time"}).buildWith(NucleusParameters.OPTIONAL_MESSAGE)};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        ServerListGeneralDataModule mod = Nucleus.getNucleus().getGeneralService().get(ServerListGeneralDataModule.class);
        if (args.hasAny("r")) {
            if (mod.getMessage().isPresent()) {
                mod.remove();
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.serverlist.message.removed", new String[0]));
                return CommandResult.success();
            }
            throw ReturnMessageException.fromKey("command.serverlist.message.noremoved", new Object[0]);
        }
        boolean linetwo = args.getOne(this.line).map(x -> x == 2).orElse(false);
        Optional onMessage = args.getOne("message");
        if (!onMessage.isPresent()) {
            boolean isValid = mod.getExpiry().map(x -> x.isAfter(Instant.now())).orElse(false);
            if (!isValid) {
                throw ReturnMessageException.fromKey("command.serverlist.message.isempty", new Object[0]);
            }
            if (linetwo) {
                mod.setLineTwo(null);
            } else {
                mod.setLineOne(null);
            }
            Optional<Text> newMessage = mod.getMessage();
            if (newMessage.isPresent()) {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.serverlist.message.set", new String[0]));
                src.sendMessage(newMessage.get());
            } else {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.serverlist.message.empty", new String[0]));
            }
            return CommandResult.success();
        }
        String nMessage = (String)onMessage.get();
        Instant endTime = args.getOne("duration").map(x -> Instant.now().plus((long)x, ChronoUnit.SECONDS)).orElseGet(() -> mod.getExpiry().map(x -> x.isBefore(Instant.now()) ? x.plusSeconds(3600L) : x).orElseGet(() -> Instant.now().plusSeconds(3600L)));
        mod.setExpiry(endTime);
        if (linetwo) {
            mod.setLineTwo(nMessage);
        } else {
            mod.setLineOne(nMessage);
        }
        Optional<Text> newMessage = mod.getMessage();
        if (newMessage.isPresent()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.serverlist.message.set", new String[0]));
            src.sendMessage(newMessage.get());
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.serverlist.message.expiry", Util.getTimeToNow(endTime)));
            return CommandResult.success();
        }
        throw ReturnMessageException.fromKey("command.serverlist.message.notset", new Object[0]);
    }
}

