/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.spawn.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularWorldService;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.modules.spawn.datamodules.SpawnWorldDataModule;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RegisterCommand(value={"setspawn"})
@Permissions
@NoModifiers
@NonnullByDefault
@EssentialsEquivalent(value={"setspawn"})
public class SetSpawnCommand
extends AbstractCommand<Player> {
    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) {
        ModularWorldService worldService = Nucleus.getNucleus().getWorldDataManager().getWorld(src.getWorld().getUniqueId()).get();
        SpawnWorldDataModule m = worldService.get(SpawnWorldDataModule.class);
        m.setSpawnRotation(src.getRotation());
        worldService.set(m);
        src.getWorld().getProperties().setSpawnPosition(src.getLocation().getBlockPosition());
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.setspawn.success", src.getWorld().getName()));
        return CommandResult.success();
    }
}

