/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warn.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.text.TextParsingUtils;
import io.github.nucleuspowered.nucleus.modules.warn.data.WarnData;
import io.github.nucleuspowered.nucleus.modules.warn.services.WarnHandler;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(suggestedLevel=SuggestedLevel.MOD)
@RunAsync
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"checkwarnings", "checkwarn", "warnings"})
public class CheckWarningsCommand
extends AbstractCommand<CommandSource> {
    private final WarnHandler handler = (WarnHandler)this.getServiceUnchecked(WarnHandler.class);
    private final String playerKey = "subject";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"-all", "a"}).flag(new String[]{"-expired", "e"}).buildWith(GenericArguments.onlyOne((CommandElement)GenericArguments.user((Text)Text.of((String)this.playerKey))))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        User user = (User)args.getOne(this.playerKey).get();
        this.handler.updateWarnings(user);
        List<WarnData> allWarnings = this.handler.getWarningsInternal(user);
        List<WarnData> warnings = args.hasAny("all") ? allWarnings : (args.hasAny("expired") ? allWarnings.stream().filter(WarnData::isExpired).collect(Collectors.toList()) : allWarnings.stream().filter(x -> !x.isExpired()).collect(Collectors.toList()));
        if (warnings.isEmpty()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkwarnings.none", user.getName()));
            return CommandResult.success();
        }
        List messages = warnings.stream().sorted(Comparator.comparing(WarnData::getDate)).map(x -> this.createMessage(allWarnings, (WarnData)x, user, src)).collect(Collectors.toList());
        messages.add(0, Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkwarnings.info", new String[0]));
        PaginationService paginationService = (PaginationService)Sponge.getGame().getServiceManager().provideUnchecked(PaginationService.class);
        paginationService.builder().title(Text.builder().color(TextColors.GOLD).append(new Text[]{Text.of((String)Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("command.checkwarnings.header", user.getName()))}).build()).padding(Text.builder().color(TextColors.YELLOW).append(new Text[]{Text.of((String)"=")}).build()).contents(messages).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private Text createMessage(List<WarnData> allData, WarnData warning, User user, CommandSource source) {
        Optional<UUID> warner = warning.getWarner();
        String name = warner.map(uuid -> Util.getUserFromUUID(warning.getWarner().get()).map(User::getName).orElse(Sponge.getServer().getConsole().getName())).orElseGet(() -> Sponge.getServer().getConsole().getName());
        String time = warning.getEndTimestamp().isPresent() ? Util.getTimeStringFromSeconds(Instant.now().until(warning.getEndTimestamp().get(), ChronoUnit.SECONDS)) : (warning.getTimeFromNextLogin().isPresent() ? Util.getTimeStringFromSeconds(warning.getTimeFromNextLogin().get().getSeconds()) : Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.restoftime", new String[0]));
        int id = allData.indexOf(warning) + 1;
        Text.Builder actions = Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkwarnings.action", new String[0]).toBuilder();
        actions.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, " > "})});
        actions.append(new Text[]{Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.RED, this.getMessageFor(source, "standard.action.delete")})}).onHover((HoverAction)TextActions.showText((Text)this.getMessageFor(source, "command.checkwarnings.hover.delete"))).onClick((ClickAction)TextActions.runCommand((String)("/removewarning --remove " + user.getName() + " " + id))).build()});
        actions.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, " - "})});
        if (!warning.isExpired()) {
            actions.append(new Text[]{Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, this.getMessageFor(source, "standard.action.expire")})}).onHover((HoverAction)TextActions.showText((Text)this.getMessageFor(source, "command.checkwarnings.hover.expire"))).onClick((ClickAction)TextActions.runCommand((String)("/removewarning " + user.getName() + " " + id))).build()});
            actions.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, " - "})});
        }
        actions.append(new Text[]{Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, this.getMessageFor(source, "standard.action.return")})}).onHover((HoverAction)TextActions.showText((Text)this.getMessageFor(source, "command.checkwarnings.hover.return"))).onClick((ClickAction)TextActions.runCommand((String)("/checkwarnings " + user.getName()))).build()});
        actions.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, " < "})});
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("MMM dd, yyyy").withZone(ZoneId.systemDefault());
        String date = dtf.format(warning.getDate());
        Text warningMessage = TextParsingUtils.addUrls(warning.getReason());
        LiteralText.Builder information = Text.builder((String)name).onHover((HoverAction)TextActions.showText((Text)this.getMessageFor(source, "command.checkwarnings.hover.check"))).onClick((ClickAction)TextActions.executeCallback(commandSource -> {
            this.sendMessageTo(source, "command.checkwarnings.id", new String[]{String.valueOf(id)});
            this.sendMessageTo(source, "command.checkwarnings.date", new String[]{date});
            this.sendMessageTo(source, "command.checkwarnings.remaining", new String[]{time});
            this.sendMessageTo(source, "command.checkwarnings.warner", new String[]{name});
            this.sendMessageTo(source, "command.checkwarnings.warning", new Text[]{warningMessage});
            commandSource.sendMessage(actions.build());
        }));
        Text.Builder message = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, information.build()})}).append(new Text[]{Text.of((String)": ")}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, warning.getReason()})});
        if (warning.isExpired()) {
            message.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GRAY, " " + Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.status.expired", new String[0])})});
        } else {
            message.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, " " + Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.for", new String[0]) + " "})});
            if (Character.isLetter(time.charAt(0))) {
                message.append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, time.substring(0, 1).toLowerCase() + time.substring(1)})});
            } else {
                message.append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, time})});
            }
        }
        return message.build();
    }
}

