/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.floo;

import info.debatty.java.stringsimilarity.Levenshtein;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import lumien.randomthings.handler.floo.FlooFireplace;
import lumien.randomthings.network.MessageUtil;
import lumien.randomthings.network.PacketHandler;
import lumien.randomthings.network.messages.MessageFlooParticles;
import lumien.randomthings.tileentity.TileEntityFlooBrick;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class FlooNetworkHandler
extends WorldSavedData {
    static final String ID = "rtFlooHandler";
    List<FlooFireplace> firePlaces = new ArrayList<FlooFireplace>();
    static final Levenshtein stringSim = new Levenshtein();

    public FlooNetworkHandler() {
        this(ID);
    }

    public FlooNetworkHandler(String id) {
        super(id);
    }

    public static FlooNetworkHandler get(World worldObj) {
        FlooNetworkHandler instance = (FlooNetworkHandler)worldObj.getPerWorldStorage().func_75742_a(FlooNetworkHandler.class, ID);
        if (instance == null) {
            instance = new FlooNetworkHandler();
            worldObj.getPerWorldStorage().func_75745_a(ID, (WorldSavedData)instance);
        }
        return instance;
    }

    public String getNameFromUUID(UUID uuid) {
        for (FlooFireplace ff : this.firePlaces) {
            if (!ff.masterUUID.equals(uuid)) continue;
            return ff.name;
        }
        return null;
    }

    public void addFirePlace(UUID creatorPlayerUUID, UUID masterUUID, String name, BlockPos currentPos) {
        FlooFireplace firePlace = new FlooFireplace(creatorPlayerUUID, masterUUID, name, currentPos);
        this.firePlaces.add(firePlace);
        this.func_76185_a();
    }

    public boolean teleport(World world, BlockPos originPos, TileEntityFlooBrick originTE, EntityPlayerMP player, String enteredDestination) {
        FlooFireplace targetFirePlace = null;
        double closest = Double.MAX_VALUE;
        for (FlooFireplace firePlace : this.firePlaces) {
            double sim;
            String firePlaceName = firePlace.getName();
            if (firePlaceName == null || !((sim = stringSim.distance(firePlaceName, enteredDestination)) < closest)) continue;
            closest = sim;
            targetFirePlace = firePlace;
        }
        if (targetFirePlace != null) {
            TileEntityFlooBrick targetTE;
            if (originPos != null && targetFirePlace.lastKnownPosition.equals((Object)originPos)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("floo.info.same", new Object[0]));
                return false;
            }
            BlockPos targetPos = targetFirePlace.getLastKnownPosition();
            TileEntity te = world.func_175625_s(targetPos);
            if (te instanceof TileEntityFlooBrick && (targetTE = (TileEntityFlooBrick)te).isMaster()) {
                EnumFacing tpFacing = targetTE.getFacing();
                BlockPos teleportTarget = targetPos.func_177984_a();
                player.field_71135_a.func_147364_a((double)teleportTarget.func_177958_n() + 0.5, (double)teleportTarget.func_177956_o(), (double)teleportTarget.func_177952_p() + 0.5, tpFacing.func_185119_l(), 0.0f);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("floo.info.teleport", new Object[]{targetFirePlace.getName()}));
                if (originPos != null && originTE != null) {
                    ArrayList<BlockPos> originPositions = new ArrayList<BlockPos>();
                    originPositions.add(originPos);
                    originPositions.addAll(originTE.getChildren());
                    MessageFlooParticles p1 = new MessageFlooParticles(originPositions);
                    MessageUtil.sendToAllWatchingPos(player.field_70170_p, originPos, p1);
                }
                ArrayList<BlockPos> destinationPositions = new ArrayList<BlockPos>();
                destinationPositions.add(targetPos);
                destinationPositions.addAll(targetTE.getChildren());
                MessageFlooParticles p2 = new MessageFlooParticles(destinationPositions);
                MessageUtil.sendToAllWatchingPos(player.field_70170_p, targetPos, p2);
                PacketHandler.INSTANCE.sendTo(p2, player);
                return true;
            }
            this.firePlaces.remove(targetFirePlace);
            this.func_76185_a();
            return this.teleport(world, originPos, originTE, player, enteredDestination);
        }
        return false;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList firePlaceTags = nbt.func_150295_c("firePlaces", 10);
        for (int i = 0; i < firePlaceTags.func_74745_c(); ++i) {
            NBTTagCompound compound = firePlaceTags.func_150305_b(i);
            FlooFireplace firePlace = new FlooFireplace();
            firePlace.readFromNBT(compound);
            this.firePlaces.add(firePlace);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList firePlaceTags = new NBTTagList();
        for (FlooFireplace firePlace : this.firePlaces) {
            NBTTagCompound firePlaceCompound = new NBTTagCompound();
            firePlace.writeToNBT(firePlaceCompound);
            firePlaceTags.func_74742_a((NBTBase)firePlaceCompound);
        }
        compound.func_74782_a("firePlaces", (NBTBase)firePlaceTags);
        return compound;
    }

    public boolean createFireplace(World worldIn, UUID uuid, String name, EntityPlayer player, BlockPos pos, List<BlockPos> brickList) {
        for (FlooFireplace firePlace : this.firePlaces) {
            if (!brickList.contains(firePlace.getLastKnownPosition()) && (name == null || firePlace.name == null || !firePlace.name.equalsIgnoreCase(name))) continue;
            return false;
        }
        this.addFirePlace(player.func_146103_bH().getId(), uuid, name, pos);
        return true;
    }

    public void updatePosition(UUID uuid, BlockPos pos) {
        for (FlooFireplace firePlace : this.firePlaces) {
            if (!firePlace.getMasterUUID().equals(uuid)) continue;
            firePlace.setPos(pos);
            break;
        }
    }

    public boolean func_76188_b() {
        return true;
    }

    public void brokenMaster(World worldIn, BlockPos pos, TileEntityFlooBrick tileEntityFlooBrick) {
        if (tileEntityFlooBrick.getUid() != null) {
            Iterator<FlooFireplace> iterator = this.firePlaces.iterator();
            while (iterator.hasNext()) {
                FlooFireplace firePlace = iterator.next();
                if (!firePlace.getMasterUUID().equals(tileEntityFlooBrick.getUid())) continue;
                iterator.remove();
            }
        }
    }

    public List<FlooFireplace> getFirePlaces() {
        return this.firePlaces;
    }

    public TileEntity getFirePlaceTE(World worldObj, UUID uuid) {
        for (FlooFireplace firePlace : this.firePlaces) {
            if (!firePlace.masterUUID.equals(uuid)) continue;
            return worldObj.func_175625_s(firePlace.lastKnownPosition);
        }
        return null;
    }
}

