/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.command;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.command.CommandExecutor;
import com.github.terminatornl.tiquality.command.CommandHub;
import com.github.terminatornl.tiquality.command.PermissionHolder;
import com.github.terminatornl.tiquality.command.SpongePermissionHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SpongeCommand
implements CommandCallable {
    public void init() {
        CommandManager commandManager = Sponge.getCommandManager();
        for (String alias : CommandHub.ALIASES) {
            if (!commandManager.containsAlias(alias)) continue;
            Tiquality.LOGGER.info("Command for '" + alias + "' has already been registered, skipping!");
            return;
        }
        Sponge.getCommandManager().register((Object)Tiquality.INSTANCE, (CommandCallable)this, CommandHub.ALIASES);
    }

    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        try {
            CommandExecutor.execute((ICommandSender)source, arguments.split(" "), new SpongePermissionHolder(source));
            return CommandResult.success();
        }
        catch (net.minecraft.command.CommandException e) {
            throw new CommandException((Text)Text.of((String)e.getMessage()), (Throwable)e);
        }
    }

    public List<String> getSuggestions(CommandSource source, String arguments, @Nullable Location<World> targetPosition) throws CommandException {
        SpongePermissionHolder holder = new SpongePermissionHolder(source);
        try {
            holder.checkPermission(PermissionHolder.Permission.USE);
            String[] split = arguments.split(" ");
            if (arguments.endsWith(" ")) {
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(split));
                list.add("");
                split = list.toArray(new String[0]);
            }
            return CommandExecutor.getSuggestions(split, holder);
        }
        catch (net.minecraft.command.CommandException e) {
            throw new CommandException((Text)Text.of((String)e.getMessage()), (Throwable)e);
        }
    }

    public boolean testPermission(CommandSource source) {
        return new SpongePermissionHolder(source).hasPermission(PermissionHolder.Permission.USE);
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)"Allows use of Tiquality commands."));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(this.getUsage(source));
    }

    public Text getUsage(CommandSource source) {
        return Text.of((String)CommandExecutor.getUsage(new SpongePermissionHolder(source)));
    }
}

