/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.integration.griefdefender;

import com.github.terminatornl.tiquality.api.event.TiqualityEvent;
import com.github.terminatornl.tiquality.integration.griefdefender.GriefDefenderHook;
import com.github.terminatornl.tiquality.integration.griefdefender.event.GDClaimCreatedFullyEvent;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.griefdefender.api.GriefDefender;
import com.griefdefender.api.claim.Claim;
import com.griefdefender.api.claim.ClaimManager;
import java.util.Set;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class EventHandler {
    public static final EventHandler INSTANCE = new EventHandler();

    private EventHandler() {
    }

    @SubscribeEvent
    public void onClaimCreate(GDClaimCreatedFullyEvent e) {
        Tracker tracker = GriefDefenderHook.findOrGetTrackerByClaim(e.getClaim());
        if (tracker != null) {
            GriefDefenderHook.setClaimTrackers(e.getClaim(), tracker, null, null);
        }
    }

    @SubscribeEvent
    public void onSetTracker(TiqualityEvent.SetBlockTrackerEvent e) {
        Location pos;
        ClaimManager claimManager = GriefDefender.getCore().getClaimManager(((World)e.getMinecraftWorld()).getUniqueId());
        Claim claim = claimManager.getClaimAt((pos = new Location((Extent)((World)e.getMinecraftWorld()), e.getPos().func_177958_n(), e.getPos().func_177956_o(), e.getPos().func_177952_p())).getBlockPosition());
        if (!GriefDefenderHook.isValidClaim(claim)) {
            return;
        }
        Tracker tracker = GriefDefenderHook.findOrGetTrackerByClaim(claim);
        e.setTracker(tracker);
    }

    @SubscribeEvent
    public void onSetTracker(TiqualityEvent.SetChunkTrackerEvent e) {
        Chunk chunk = (Chunk)e.getChunk();
        ClaimManager claimManager = GriefDefender.getCore().getClaimManager(((World)chunk.func_177412_p()).getUniqueId());
        long chunkLong = ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h);
        Set claimSet = (Set)claimManager.getChunksToClaimsMap().get(chunkLong);
        if (claimSet == null) {
            return;
        }
        for (Claim claim : claimSet) {
            if (!GriefDefenderHook.isValidClaim(claim)) continue;
            e.setPerBlockMode();
            return;
        }
    }
}

