/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.integration.griefprevention;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.api.Tracking;
import com.github.terminatornl.tiquality.integration.griefprevention.AdminClaimTracker;
import com.github.terminatornl.tiquality.integration.griefprevention.EventHandler;
import com.github.terminatornl.tiquality.integration.griefprevention.event.GPClaimCreatedFullyEvent;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.tracking.PlayerTracker;
import com.github.terminatornl.tiquality.util.ForgeData;
import com.github.terminatornl.tiquality.util.Scheduler;
import com.github.terminatornl.tiquality.world.WorldHelper;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ryanhamshire.griefprevention.GriefPrevention;
import me.ryanhamshire.griefprevention.api.claim.Claim;
import me.ryanhamshire.griefprevention.api.claim.ClaimType;
import me.ryanhamshire.griefprevention.api.event.ChangeClaimEvent;
import me.ryanhamshire.griefprevention.api.event.CreateClaimEvent;
import me.ryanhamshire.griefprevention.api.event.TransferClaimEvent;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class GriefPreventionHook {
    private static final CreateClaimEventHandler createClaimHandler = new CreateClaimEventHandler();
    private static final ChangeClaimEventHandler claimChangeHandler = new ChangeClaimEventHandler();
    private static final TransferClaimEventHandler transferClaimHandler = new TransferClaimEventHandler();

    public static void setClaimTrackers(Claim claim, Tracker tracker, Runnable callback, Runnable beforeRun) {
        Location least = claim.getLesserBoundaryCorner();
        Location most = claim.getGreaterBoundaryCorner();
        if (least == null || most == null) {
            return;
        }
        TiqualityWorld world = (TiqualityWorld)least.getExtent();
        BlockPos leastPos = new BlockPos(least.getBlockX(), least.getBlockY(), least.getBlockZ());
        BlockPos mostPos = new BlockPos(most.getBlockX(), most.getBlockY(), most.getBlockZ());
        world.setTiqualityTrackerCuboidAsync(leastPos, mostPos, tracker, callback, beforeRun);
    }

    public static void loadClaimsForcibly(final ICommandSender sender) {
        final AtomicInteger counter = new AtomicInteger(0);
        Tiquality.LOGGER.info("Importing griefprevention claims...");
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "[Tiquality] Import started."));
        ArrayList list = new ArrayList();
        for (World world : Sponge.getServer().getWorlds()) {
            list.addAll(GriefPrevention.getApi().getClaimManager(world).getWorldClaims());
        }
        for (Claim claim : list) {
            if (!GriefPreventionHook.isValidClaim(claim)) continue;
            counter.getAndIncrement();
            Text owner = claim.getOwnerName();
            net.minecraft.world.World world = (net.minecraft.world.World)claim.getWorld();
            Location pos = claim.getLesserBoundaryCorner();
            final String identifier = (owner != null ? owner.toPlain() : "Unknown") + " at DIM=" + (world != null ? String.valueOf(world.field_73011_w.getDimension()) : "Unknown") + " " + (pos != null ? "X: " + pos.getBlockX() + " Z: " + pos.getBlockZ() : "unknown");
            GriefPreventionHook.setClaimTrackers(claim, PlayerTracker.getOrCreatePlayerTrackerByProfile((TiqualityWorld)world, ForgeData.getGameProfileByUUID(claim.getOwnerUniqueId())), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String message = "[Tiquality] Remaining claims: " + (counter.getAndDecrement() - 1);
                    Tiquality.LOGGER.info(message);
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + message));
                    AtomicInteger atomicInteger = counter;
                    synchronized (atomicInteger) {
                        counter.notifyAll();
                    }
                }
            }, new Runnable(){

                @Override
                public void run() {
                    Tiquality.LOGGER.info("Importing: " + identifier);
                }
            });
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (counter.get() > 0) {
                        AtomicInteger atomicInteger = counter;
                        synchronized (atomicInteger) {
                            counter.wait(5000L);
                        }
                        int tasks = WorldHelper.getQueuedTasks();
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_GRAY + "[Tiquality] " + tasks + " tasks to process left."));
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "[Tiquality] Import finished."));
                    Tiquality.LOGGER.info("Import finished.");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public static boolean isValidClaim(Claim claim) {
        boolean isInvalid = claim == null || claim.isWilderness() || claim.getOwnerUniqueId() == null;
        return !isInvalid;
    }

    @Nullable
    public static Tracker findOrGetTrackerByClaim(@Nonnull Claim claim) {
        if (claim.isWilderness()) {
            return null;
        }
        if (claim.isAdminClaim()) {
            return AdminClaimTracker.INSTANCE;
        }
        if (claim.getOwnerUniqueId() == null) {
            throw new IllegalArgumentException("Claim owner is null!");
        }
        GameProfile profile = ForgeData.getGameProfileByUUID(claim.getOwnerUniqueId());
        return PlayerTracker.getOrCreatePlayerTrackerByProfile((TiqualityWorld)claim.getWorld(), profile);
    }

    public static void importSingleClaim(final EntityPlayer sender) throws CommandException {
        BlockPos pos = sender.func_180425_c();
        Claim claim = GriefPrevention.getApi().getClaimManager((World)sender.func_130014_f_()).getClaimAt(new Location((Extent)((World)sender.func_130014_f_()), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        if (claim == null) {
            throw new CommandException("Claim not found, please stand in your claim where no tracker is present and run the command again.", new Object[0]);
        }
        if (!GriefPreventionHook.isValidClaim(claim)) {
            throw new CommandException("Claim is found, but it is not of a valid type.", new Object[0]);
        }
        TiqualityWorld world = (TiqualityWorld)sender.func_130014_f_();
        Tracker existingTracker = world.getTiqualityTracker(pos);
        if (existingTracker != null) {
            throw new CommandException("There's already a tracker present: " + existingTracker.getInfo().func_150265_g(), new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "[Tiquality] Import queued."));
        Location least = claim.getLesserBoundaryCorner();
        Location most = claim.getGreaterBoundaryCorner();
        if (least == null || most == null) {
            return;
        }
        BlockPos leastPos = new BlockPos(least.getBlockX(), least.getBlockY(), least.getBlockZ());
        BlockPos mostPos = new BlockPos(most.getBlockX(), most.getBlockY(), most.getBlockZ());
        world.setTiqualityTrackerCuboidAsync(leastPos, mostPos, PlayerTracker.getOrCreatePlayerTrackerByProfile(world, ForgeData.getGameProfileByUUID(claim.getOwnerUniqueId())), new Runnable(){

            @Override
            public void run() {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Importing your claim..."));
            }
        }, new Runnable(){

            @Override
            public void run() {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Import complete!"));
            }
        });
    }

    public static void init() {
        Sponge.getEventManager().registerListener((Object)Tiquality.INSTANCE, CreateClaimEvent.class, (EventListener)createClaimHandler);
        Sponge.getEventManager().registerListener((Object)Tiquality.INSTANCE, ChangeClaimEvent.class, (EventListener)claimChangeHandler);
        Sponge.getEventManager().registerListener((Object)Tiquality.INSTANCE, TransferClaimEvent.class, (EventListener)transferClaimHandler);
        Tracking.registerCustomTracker("GPAdmin", AdminClaimTracker.class);
        MinecraftForge.EVENT_BUS.register((Object)EventHandler.INSTANCE);
    }

    private static class TransferClaimEventHandler
    implements EventListener<TransferClaimEvent> {
        private TransferClaimEventHandler() {
        }

        public void handle(@Nonnull TransferClaimEvent event) {
            for (Claim claim : event.getClaims()) {
                Tracker tracker = GriefPreventionHook.findOrGetTrackerByClaim(claim);
                if (tracker == null) continue;
                GriefPreventionHook.setClaimTrackers(claim, tracker, null, null);
            }
        }
    }

    private static class ChangeClaimEventHandler
    implements EventListener<ChangeClaimEvent> {
        private ChangeClaimEventHandler() {
        }

        public void handle(@Nonnull ChangeClaimEvent event) {
            if (event instanceof ChangeClaimEvent.Type) {
                ChangeClaimEvent.Type typeChangeEvent = (ChangeClaimEvent.Type)event;
                for (final Claim claim : event.getClaims()) {
                    ClaimType originalType = typeChangeEvent.getOriginalType();
                    ClaimType newType = typeChangeEvent.getType();
                    if (originalType == ClaimType.BASIC || originalType == ClaimType.TOWN || originalType == ClaimType.SUBDIVISION) {
                        if (newType != ClaimType.ADMIN) continue;
                        GriefPreventionHook.setClaimTrackers(claim, AdminClaimTracker.INSTANCE, null, null);
                        continue;
                    }
                    if (originalType != ClaimType.ADMIN || newType != ClaimType.BASIC && newType != ClaimType.TOWN && newType != ClaimType.SUBDIVISION) continue;
                    final Location lesser = claim.getLesserBoundaryCorner();
                    Scheduler.INSTANCE.schedule(new Runnable(){

                        @Override
                        public void run() {
                            TiqualityWorld world = (TiqualityWorld)claim.getWorld();
                            Tracker newTracker = GriefPreventionHook.findOrGetTrackerByClaim(GriefPrevention.getApi().getClaimManager((World)world).getClaimAt(lesser));
                            if (newTracker == null) {
                                return;
                            }
                            GriefPreventionHook.setClaimTrackers(claim, newTracker, null, null);
                        }
                    });
                }
            } else if (event instanceof ChangeClaimEvent.Resize) {
                final Claim resizedClaim = ((ChangeClaimEvent.Resize)event).getResizedClaim();
                final Tracker tracker = GriefPreventionHook.findOrGetTrackerByClaim(resizedClaim);
                if (tracker == null) {
                    return;
                }
                Tiquality.SCHEDULER.schedule(new Runnable(){

                    @Override
                    public void run() {
                        GriefPreventionHook.setClaimTrackers(resizedClaim, tracker, null, null);
                    }
                });
            }
        }
    }

    private static class CreateClaimEventHandler
    implements EventListener<CreateClaimEvent> {
        private CreateClaimEventHandler() {
        }

        public void handle(final @Nonnull CreateClaimEvent event) {
            Tiquality.SCHEDULER.schedule(new Runnable(){

                @Override
                public void run() {
                    for (Claim claim : event.getClaims()) {
                        MinecraftForge.EVENT_BUS.post((Event)new GPClaimCreatedFullyEvent(claim));
                    }
                }
            });
        }
    }
}

