/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.interfaces;

import com.github.terminatornl.tiquality.api.TiqualityException;
import com.github.terminatornl.tiquality.interfaces.TiqualityChunk;
import com.github.terminatornl.tiquality.interfaces.TiqualityEntity;
import com.github.terminatornl.tiquality.interfaces.TiqualitySimpleTickable;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.profiling.ProfilingKey;
import com.github.terminatornl.tiquality.profiling.TickLogger;
import com.github.terminatornl.tiquality.tracking.TrackerHolder;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public interface Tracker {
    public Tracker load(TiqualityWorld var1, NBTTagCompound var2);

    default public void consume(long time) {
        if (this.canProfile()) {
            throw new RuntimeException("You must override the consume method!");
        }
    }

    public boolean shouldSaveToDisk();

    @Nonnull
    public NBTTagCompound getNBT();

    @Nonnull
    public ProfilingKey startProfiler(long var1) throws TiqualityException.TrackerCannotProfileException, TiqualityException.TrackerAlreadyProfilingException;

    @Nonnull
    public TickLogger stopProfiler(ProfilingKey var1) throws TiqualityException.TrackerWasNotProfilingException, TiqualityException.InvalidKeyException;

    @Nonnull
    public TickLogger getTickLogger() throws TiqualityException.TrackerWasNotProfilingException;

    public boolean canProfile();

    public boolean isProfiling();

    public long getProfileEndTime();

    public void setNextTickTime(long var1);

    default public void tick() {
    }

    public double getMultiplier(GameProfile[] var1);

    public long getRemainingTime();

    public boolean needsTick();

    public void tickSimpleTickable(TiqualitySimpleTickable var1);

    public void tickEntity(TiqualityEntity var1);

    public void doBlockTick(Block var1, World var2, BlockPos var3, IBlockState var4, Random var5);

    public void doRandomBlockTick(Block var1, World var2, BlockPos var3, IBlockState var4, Random var5);

    public void grantTick();

    public void addTickableToQueue(TiqualitySimpleTickable var1);

    public void associateChunk(TiqualityChunk var1);

    public void associateDelegatingTracker(Tracker var1);

    public void removeDelegatingTracker(Tracker var1);

    @Nonnull
    public List<GameProfile> getAssociatedPlayers();

    public String toString();

    @Nonnull
    public TextComponentString getInfo();

    @Nonnull
    public String getIdentifier();

    public int getHashCode();

    public boolean shouldUnload();

    @OverridingMethodsMustInvokeSuper
    public void onUnload();

    public TrackerHolder getHolder();

    public void setHolder(TrackerHolder var1);

    default public void notifyFallingBehind(double ratio) {
    }

    public boolean isLoaded();

    public boolean equalsSaved(NBTTagCompound var1);
}

