/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.memory;

import com.github.terminatornl.tiquality.interfaces.TiqualityChunk;
import java.lang.ref.WeakReference;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;

public class WeakReferencedChunk
extends WeakReference<TiqualityChunk> {
    public WeakReferencedChunk(TiqualityChunk chunk) {
        super(chunk);
    }

    public boolean isChunkLoaded() {
        TiqualityChunk chunk = (TiqualityChunk)this.get();
        return chunk != null && chunk.isChunkLoaded();
    }

    public void tryUnloadChunk() {
        TiqualityChunk chunk = (TiqualityChunk)this.get();
        if (chunk == null) {
            return;
        }
        IChunkProvider providerRaw = chunk.getMinecraftChunk().func_177412_p().func_72863_F();
        if (providerRaw instanceof ChunkProviderServer) {
            ((ChunkProviderServer)providerRaw).func_189549_a((Chunk)chunk);
        }
    }

    public int hashCode() {
        TiqualityChunk chunk = (TiqualityChunk)this.get();
        return chunk == null ? 0 : chunk.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof WeakReferencedChunk)) {
            return false;
        }
        WeakReferencedChunk other = (WeakReferencedChunk)o;
        TiqualityChunk thisChunk = (TiqualityChunk)this.get();
        TiqualityChunk otherChunk = (TiqualityChunk)other.get();
        if (this == o || thisChunk == otherChunk) {
            return true;
        }
        if (thisChunk == null || otherChunk == null) {
            return false;
        }
        return thisChunk.getMinecraftChunk().func_76632_l().equals((Object)otherChunk.getMinecraftChunk().func_76632_l());
    }
}

