/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.mixin;

import com.github.terminatornl.tiquality.interfaces.TiqualityChunk;
import com.github.terminatornl.tiquality.interfaces.TiqualityEntity;
import com.github.terminatornl.tiquality.interfaces.TiqualitySimpleTickable;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.mixinhelper.MixinConfigPlugin;
import com.github.terminatornl.tiquality.world.SpongeChunkLoader;
import com.github.terminatornl.tiquality.world.WorldHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={WorldServer.class}, priority=999)
public abstract class MixinWorldServerCommon
extends World
implements TiqualityWorld {
    protected MixinWorldServerCommon(ISaveHandler saveHandlerIn, WorldInfo info, WorldProvider providerIn, Profiler profilerIn, boolean client) {
        super(saveHandlerIn, info, providerIn, profilerIn, client);
        throw new RuntimeException("This should never run...");
    }

    @Nonnull
    @Shadow
    public abstract ChunkProviderServer func_72863_F();

    @Override
    @Nonnull
    public TiqualityChunk getTiqualityChunk(BlockPos pos) {
        return MixinConfigPlugin.spongePresent ? SpongeChunkLoader.getChunkForced(this, new ChunkPos(pos)) : (TiqualityChunk)this.func_175726_f(pos);
    }

    @Override
    public void tiquality_mark(BlockPos pos) {
        this.getTiqualityChunk(pos).tiquality_mark(pos);
    }

    @Override
    public void tiquality_unMark(BlockPos pos) {
        this.getTiqualityChunk(pos).tiquality_unMark(pos);
    }

    @Override
    public boolean tiquality_isMarked(BlockPos pos) {
        return this.getTiqualityChunk(pos).tiquality_isMarked(pos);
    }

    @Override
    public boolean tiquality_isMarkedThorough(BlockPos pos) {
        boolean isBlockmarked = this.tiquality_isMarked(pos);
        if (isBlockmarked) {
            return true;
        }
        TileEntity entity = this.func_175625_s(pos);
        return entity != null && ((TiqualitySimpleTickable)entity).tiquality_isMarked();
    }

    @Override
    @Nullable
    public Tracker getTiqualityTracker(BlockPos pos) {
        return this.getTiqualityChunk(pos).tiquality_findTrackerByBlockPos(pos);
    }

    @Override
    public void setTiqualityTracker(BlockPos pos, Tracker tracker) {
        this.getTiqualityChunk(pos).tiquality_setTrackedPosition(pos, tracker);
    }

    @Override
    public void setTiqualityTrackerCuboidAsync(BlockPos start, BlockPos end, Tracker tracker, Runnable callback) {
        WorldHelper.setTrackerCuboid(this, start, end, tracker, callback, null);
    }

    @Override
    public void setTiqualityTrackerCuboidAsync(BlockPos start, BlockPos end, Tracker tracker, Runnable callback, Runnable beforeRun) {
        WorldHelper.setTrackerCuboid(this, start, end, tracker, callback, beforeRun);
    }

    @Override
    @Nonnull
    public World getMinecraftWorld() {
        return this;
    }

    @Override
    @Nonnull
    public List<TiqualityEntity> getTiqualityEntities(boolean trackersOnly) {
        if (trackersOnly) {
            List list = new ArrayList(this.field_72996_f);
            list.removeIf(entity -> entity.getTrackerHolder() == null);
            return list;
        }
        return Collections.unmodifiableList(this.field_72996_f);
    }
}

