/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.mixinhelper;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.mixinhelper.MixinConfigPlugin;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class MixinValidator {
    public static void validate() {
        HashMap<String, String> FAILED_OR_UNLOADED_MIXINS = new HashMap<String, String>(MixinConfigPlugin.MIXINS_TO_LOAD);
        for (String string : new HashSet<String>(FAILED_OR_UNLOADED_MIXINS.values())) {
            try {
                Tiquality.LOGGER.info("Loading mixin target class: " + string);
                Class.forName(string);
            }
            catch (Exception e) {
                Tiquality.LOGGER.warn("Failed to load class: " + string + ". This is required to apply mixins!");
                e.printStackTrace();
            }
        }
        if (MixinConfigPlugin.MIXINS_TO_LOAD.size() > 0) {
            Tiquality.LOGGER.fatal("Not all required mixins have been applied!");
            Tiquality.LOGGER.fatal("To prevent you from wasting your time, the process has ended.");
            Tiquality.LOGGER.fatal("");
            Tiquality.LOGGER.fatal("Required mixins that have not been applied:");
            for (Map.Entry entry : MixinConfigPlugin.MIXINS_TO_LOAD.entrySet()) {
                Tiquality.LOGGER.fatal("- " + (String)entry.getKey() + " targeting: " + (String)entry.getValue());
            }
            Tiquality.LOGGER.fatal("");
            Tiquality.LOGGER.fatal("This means that Tiquality will not function properly.");
            Tiquality.LOGGER.fatal("Make sure your versions are correct for Forge as well as SpongeForge.");
            Tiquality.LOGGER.fatal("");
            FMLCommonHandler.instance().exitJava(1, false);
        } else {
            Tiquality.LOGGER.info("All mixins have been applied. If they were not overridden by another mod, everything should work.");
        }
    }
}

