/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.mixinhelper.extended;

import com.github.terminatornl.tiquality.mixinhelper.MixinConfigPlugin;
import java.lang.reflect.Field;
import java.util.ListIterator;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Debugging {
    public static void dumpClassToFatalLog(ClassNode classNode) {
        MixinConfigPlugin.LOGGER.fatal("Dumping class methods: " + classNode.name);
        if (classNode.methods == null) {
            MixinConfigPlugin.LOGGER.fatal("No methods inside class");
            return;
        }
        for (MethodNode method : classNode.methods) {
            MixinConfigPlugin.LOGGER.fatal("Method name: " + method.name);
            MixinConfigPlugin.LOGGER.fatal("Method desc: " + method.desc);
            MixinConfigPlugin.LOGGER.fatal("Nodes: " + Debugging.getInstructions(method));
        }
    }

    public static String getInstructions(MethodNode method) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        ListIterator it = method.instructions.iterator();
        while (it.hasNext()) {
            builder.append(Debugging.getInstructionText((AbstractInsnNode)it.next()));
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String translateOpcode(int opcode) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        try {
            for (Field field : Opcodes.class.getFields()) {
                if (opcode != (Integer)field.get(null)) continue;
                if (builder.length() > 1) {
                    builder.append("/");
                }
                builder.append(field.getName());
            }
            builder.append(") (");
            builder.append(opcode);
            builder.append(")");
            return builder.toString();
        }
        catch (Exception e) {
            return "Unknown, error: " + e.getLocalizedMessage();
        }
    }

    public static String getInstructionText(AbstractInsnNode node) {
        String translation = Debugging.translateOpcode(node.getOpcode());
        if (node instanceof LabelNode) {
            return "label: " + ((LabelNode)node).getLabel() + " " + translation;
        }
        if (node instanceof FrameNode) {
            return "\tframe: L:" + ((FrameNode)node).local + " S:" + ((FrameNode)node).stack + " " + translation;
        }
        if (node instanceof LineNumberNode) {
            return "\tline number: " + ((LineNumberNode)node).line + " " + translation;
        }
        if (node instanceof InsnNode) {
            return "\tinsn: " + translation;
        }
        if (node instanceof JumpInsnNode) {
            return "\tjump: " + ((JumpInsnNode)node).label.getLabel() + " " + translation;
        }
        if (node instanceof FieldInsnNode) {
            return "\tfield: " + ((FieldInsnNode)node).name + " " + translation;
        }
        if (node instanceof VarInsnNode) {
            return "\tvar: " + ((VarInsnNode)node).var + " " + translation;
        }
        if (node instanceof MethodInsnNode) {
            return "\tmethod: " + ((MethodInsnNode)node).owner + "." + ((MethodInsnNode)node).name + ", " + ((MethodInsnNode)node).desc + " " + translation;
        }
        if (node instanceof IincInsnNode) {
            return "\tinc: " + ((IincInsnNode)node).incr + " " + ((IincInsnNode)node).var;
        }
        if (node instanceof TypeInsnNode) {
            return "\ttype: " + ((TypeInsnNode)node).desc;
        }
        return "\tUnknown: " + node.toString() + node.getClass().toGenericString();
    }
}

