/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.mixinhelper.extended;

import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodHelper {
    public static boolean isExcluded(MethodNode node) {
        if (node.visibleAnnotations == null) {
            return false;
        }
        for (AnnotationNode a : node.visibleAnnotations) {
            if (!"Lcom/github/terminatornl/tiquality/mixinhelper/extended/DynamicExclusion;".equals(a.desc)) continue;
            return true;
        }
        return false;
    }

    public static void findMethods(@Nullable String nameRegex, @Nullable String signatureRegex, ClassNode classNode, Handler handler) {
        Pattern signaturePattern;
        if (nameRegex != null && nameRegex.equals("")) {
            nameRegex = null;
        }
        if (signatureRegex != null && signatureRegex.equals("")) {
            signatureRegex = null;
        }
        Pattern namePattern = nameRegex == null ? null : Pattern.compile(nameRegex);
        Pattern pattern = signaturePattern = signatureRegex == null ? null : Pattern.compile(signatureRegex);
        if (namePattern != null) {
            for (MethodNode node : classNode.methods) {
                if (!namePattern.matcher(node.name).find()) continue;
                if (signaturePattern == null) {
                    handler.onFoundMethod(node);
                    continue;
                }
                if (node.signature == null || !signaturePattern.matcher(node.signature).find()) continue;
                handler.onFoundMethod(node);
            }
        } else if (signaturePattern != null) {
            for (MethodNode node : classNode.methods) {
                if (!signaturePattern.matcher(node.signature).find()) continue;
                handler.onFoundMethod(node);
            }
        } else {
            throw new IllegalArgumentException("Namepattern and SignaturePattern cannot both be null!");
        }
    }

    public static interface Handler {
        public void onFoundMethod(MethodNode var1);
    }
}

