/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.monitor;

import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.tracking.TrackerManager;
import com.mojang.authlib.GameProfile;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickMaster {
    public static long TICK_DURATION = 50000000L;
    private final MinecraftServer server;
    private long startTime = 0L;

    public TickMaster(MinecraftServer server) {
        this.server = server;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            this.startTime = System.nanoTime();
            final GameProfile[] cache = this.server.func_152357_F();
            Double totalWeight_1 = TrackerManager.foreach(new TrackerManager.Action<Double>(){

                @Override
                public void each(Tracker tracker) {
                    this.value = this.value == null ? Double.valueOf(tracker.getMultiplier(cache)) : Double.valueOf((Double)this.value + tracker.getMultiplier(cache));
                }
            });
            final double totalWeight = totalWeight_1 != null ? Math.max(1.0, totalWeight_1) : 1.0;
            TrackerManager.foreach(new TrackerManager.Action<Object>(){

                @Override
                public void each(Tracker tracker) {
                    long time = Math.round((double)TICK_DURATION * (tracker.getMultiplier(cache) / totalWeight));
                    tracker.setNextTickTime(time);
                }
            });
            TrackerManager.foreach(new TrackerManager.Action<Object>(){

                @Override
                public void each(Tracker tracker) {
                    tracker.tick();
                }
            });
        } else if (e.phase == TickEvent.Phase.END) {
            TrackerManager.tickUntil(this.startTime + TICK_DURATION);
            TrackerManager.removeInactiveTrackers();
        }
    }

    public long getThisTickEndTime() {
        return this.startTime + TICK_DURATION;
    }
}

