/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.monitor;

import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.tracking.DenyTracker;
import com.github.terminatornl.tiquality.tracking.PlayerTracker;
import com.github.terminatornl.tiquality.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TrackingTool {
    public static final TextFormatting[] COLORSCALE = new TextFormatting[]{TextFormatting.GRAY, TextFormatting.WHITE};
    private final EntityPlayerMP player;
    private long endTime = 0L;
    private BlockPos selectedPos;
    private int step = 0;
    private long lastTime = 0L;
    private int timeout = 0;

    public TrackingTool(@Nonnull EntityPlayerMP player) {
        this.player = player;
    }

    public void start(int time_in_ms) {
        this.timeout = time_in_ms;
        this.endTime = System.currentTimeMillis() + (long)this.timeout;
        if (this.player.func_193105_t()) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void stop() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        if (this.player.func_193105_t()) {
            return;
        }
        Utils.sendStatusBarMessage((EntityPlayer)this.player, (ITextComponent)new TextComponentString("Tracking tool stopped."));
    }

    private void sendTime() {
        Utils.sendStatusBarMessage((EntityPlayer)this.player, (ITextComponent)new TextComponentString("Tracking tool started, aim at a block and sneak to track it. Time left: " + ((this.endTime - System.currentTimeMillis()) / 1000L + 1L) + "s"));
    }

    @SubscribeEvent
    public void onUpdate(TickEvent.ServerTickEvent e) {
        if (System.currentTimeMillis() > this.endTime) {
            this.stop();
            return;
        }
        if (this.player.func_193105_t()) {
            this.stop();
            return;
        }
        if (!this.player.func_70093_af()) {
            this.sendTime();
            return;
        }
        if (System.currentTimeMillis() - 100L < this.lastTime) {
            return;
        }
        this.lastTime = System.currentTimeMillis();
        RayTraceResult result = this.player.field_70170_p.func_72933_a(this.player.func_174824_e(1.0f), Utils.getLookVec((Entity)this.player, 25));
        if (result == null) {
            Utils.sendStatusBarMessage((EntityPlayer)this.player, (ITextComponent)new TextComponentString("No block found."));
            return;
        }
        this.endTime = System.currentTimeMillis() + (long)this.timeout;
        this.step = result.func_178782_a().equals((Object)this.selectedPos) ? ++this.step : 0;
        this.selectedPos = result.func_178782_a();
        Tracker tracker = ((TiqualityWorld)this.player.field_70170_p).getTiqualityTracker(this.selectedPos);
        if (tracker != null && tracker != DenyTracker.INSTANCE) {
            Utils.sendStatusBarMessage((EntityPlayer)this.player, (ITextComponent)new TextComponentString(TextFormatting.GRAY + tracker.getInfo().func_150265_g()));
            return;
        }
        if (this.step == COLORSCALE.length) {
            --this.step;
            ((TiqualityWorld)this.player.field_70170_p).setTiqualityTracker(this.selectedPos, PlayerTracker.getOrCreatePlayerTrackerByProfile((TiqualityWorld)this.player.field_70170_p, this.player.func_146103_bH()));
            return;
        }
        Block block = this.player.field_70170_p.func_180495_p(this.selectedPos).func_177230_c();
        String text = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
        String dots = new String(new char[this.step]).replace("\u0000", ".");
        Utils.sendStatusBarMessage((EntityPlayer)this.player, (ITextComponent)new TextComponentString(COLORSCALE[this.step] + text + dots));
    }
}

