/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.profiling;

import com.github.terminatornl.tiquality.api.Location;
import com.github.terminatornl.tiquality.util.ForgetFulProgrammerException;
import com.github.terminatornl.tiquality.util.Unloaded;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class ReferencedTickable {

    public static class EntityReference
    extends Reference {
        private int dimension;
        private UUID uuid;

        public EntityReference(int dimension, UUID uuid) {
            this.dimension = dimension;
            this.uuid = uuid;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public ReferenceId getId() {
            return new ReferenceId(ReferenceId.Type.ENTITY, this.dimension, (int)(this.uuid.getMostSignificantBits() >> 32), (int)this.uuid.getMostSignificantBits(), (int)(this.uuid.getLeastSignificantBits() >> 32), (int)this.uuid.getLeastSignificantBits());
        }

        @Override
        @Nonnull
        public ITextComponent getName() {
            WorldServer world = DimensionManager.getWorld((int)this.dimension, (boolean)true);
            if (world == null) {
                DimensionManager.initDimension((int)this.dimension);
                world = DimensionManager.getWorld((int)this.dimension);
            }
            if (world == null) {
                return new TextComponentString(TextFormatting.RED + "Entity: Unloaded");
            }
            Entity entity = world.func_175733_a(this.uuid);
            if (entity == null) {
                return new TextComponentString(TextFormatting.RED + "Entity: Dead");
            }
            ITextComponent displayName = entity.func_145748_c_();
            if (displayName != null) {
                return displayName;
            }
            String text = entity.func_70005_c_();
            if (text != null) {
                return new TextComponentString(text);
            }
            return new TextComponentString(TextFormatting.YELLOW + entity.getClass().getName());
        }

        @Override
        @Nullable
        public Location<Integer, BlockPos> currentPos() {
            Entity entity;
            WorldServer world = DimensionManager.getWorld((int)this.dimension, (boolean)true);
            if (world == null) {
                DimensionManager.initDimension((int)this.dimension);
                world = DimensionManager.getWorld((int)this.dimension);
            }
            if ((entity = world.func_175733_a(this.uuid)) == null) {
                return null;
            }
            return new Location<Integer, BlockPos>(entity.field_71093_bK, entity.func_180425_c());
        }

        @Override
        @Nonnull
        public Class getReferencedClass() {
            WorldServer world = DimensionManager.getWorld((int)this.dimension, (boolean)true);
            if (world == null) {
                DimensionManager.initDimension((int)this.dimension);
                world = DimensionManager.getWorld((int)this.dimension);
            }
            if (world == null) {
                return Unloaded.World.class;
            }
            Entity entity = world.func_175733_a(this.uuid);
            if (entity == null) {
                return Unloaded.Entity.class;
            }
            return entity.getClass();
        }

        @Override
        @Nullable
        public ResourceLocation getResourceLocation() {
            WorldServer world = DimensionManager.getWorld((int)this.dimension, (boolean)true);
            if (world == null) {
                DimensionManager.initDimension((int)this.dimension);
                world = DimensionManager.getWorld((int)this.dimension);
            }
            if (world == null) {
                return null;
            }
            Entity entity = world.func_175733_a(this.uuid);
            if (entity == null) {
                return null;
            }
            EntityEntry entry = EntityRegistry.getEntry(entity.getClass());
            if (entry == null) {
                return null;
            }
            return entry.getRegistryName();
        }
    }

    public static class BlockReference
    extends Reference {
        private int dimension;
        private BlockPos pos;

        public BlockReference(int dimension, BlockPos pos) {
            this.dimension = dimension;
            this.pos = pos;
        }

        public int getDimension() {
            return this.dimension;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public ReferenceId getId() {
            return new ReferenceId(ReferenceId.Type.BLOCK, this.dimension, this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), 0);
        }

        @Override
        @Nonnull
        public ITextComponent getName() {
            WorldServer world = DimensionManager.getWorld((int)this.dimension, (boolean)true);
            if (world == null) {
                DimensionManager.initDimension((int)this.dimension);
                world = DimensionManager.getWorld((int)this.dimension);
            }
            if (world == null) {
                return new TextComponentString(TextFormatting.RED + "World: Unloaded");
            }
            Block block = world.func_180495_p(this.pos).func_177230_c();
            return new TextComponentString(block.func_149732_F());
        }

        @Override
        @Nonnull
        public Class getReferencedClass() {
            WorldServer world = DimensionManager.getWorld((int)this.dimension, (boolean)true);
            if (world == null) {
                DimensionManager.initDimension((int)this.dimension);
                world = DimensionManager.getWorld((int)this.dimension);
            }
            if (world == null) {
                return Unloaded.World.class;
            }
            return world.func_180495_p(this.pos).func_177230_c().getClass();
        }

        @Override
        @Nullable
        public ResourceLocation getResourceLocation() {
            WorldServer world = DimensionManager.getWorld((int)this.dimension, (boolean)true);
            if (world == null) {
                DimensionManager.initDimension((int)this.dimension);
                world = DimensionManager.getWorld((int)this.dimension);
            }
            if (world == null) {
                return null;
            }
            return world.func_180495_p(this.pos).func_177230_c().getRegistryName();
        }

        @Override
        @Nullable
        public Location<Integer, BlockPos> currentPos() {
            return new Location<Integer, BlockPos>(this.dimension, this.pos);
        }
    }

    public static class ReferenceId
    implements Comparable,
    IMessage {
        Type type;
        int data1;
        int data2;
        int data3;
        int data4;
        int data5;

        public ReferenceId(ByteBuf buf) {
            this.fromBytes(buf);
        }

        ReferenceId(Type type, int data1, int data2, int data3, int data4, int data5) {
            this.type = type;
            this.data1 = data1;
            this.data2 = data2;
            this.data3 = data3;
            this.data4 = data4;
            this.data5 = data5;
        }

        public static ReferenceId getId(Reference tickable) {
            if (tickable instanceof BlockReference) {
                BlockReference reference = (BlockReference)tickable;
                return new ReferenceId(Type.BLOCK, reference.dimension, reference.pos.func_177958_n(), reference.pos.func_177956_o(), reference.pos.func_177952_p(), 0);
            }
            if (tickable instanceof EntityReference) {
                EntityReference reference = (EntityReference)tickable;
                return new ReferenceId(Type.ENTITY, reference.dimension, (int)(reference.uuid.getMostSignificantBits() >> 32), (int)reference.uuid.getMostSignificantBits(), (int)(reference.uuid.getLeastSignificantBits() >> 32), (int)reference.uuid.getLeastSignificantBits());
            }
            throw new ForgetFulProgrammerException("unidentified class: " + tickable.getClass());
        }

        public Type getType() {
            return this.type;
        }

        @Nonnull
        public Reference convert() {
            switch (this.type) {
                case BLOCK: {
                    return new BlockReference(this.data1, new BlockPos(this.data2, this.data3, this.data4));
                }
                case ENTITY: {
                    long mostSignificantPart1 = (long)this.data2 << 32;
                    long mostSignificantPart2 = (long)this.data3 & 0xFFFFFFFFL;
                    long mostSignificantBits = mostSignificantPart1 | mostSignificantPart2;
                    long leastSignificantPart1 = (long)this.data4 << 32;
                    long leastSignificantPart2 = (long)this.data5 & 0xFFFFFFFFL;
                    long leastSignificantBits = leastSignificantPart1 | leastSignificantPart2;
                    return new EntityReference(this.data1, new UUID(mostSignificantBits, leastSignificantBits));
                }
            }
            throw new ForgetFulProgrammerException("unidentified type: " + (Object)((Object)this.type));
        }

        public int compareTo(@Nonnull Object o) {
            if (o instanceof ReferenceId) {
                ReferenceId other = (ReferenceId)o;
                int c = Integer.compare(this.type.getByte(), other.type.getByte());
                if (c != 0) {
                    return c;
                }
                c = Integer.compare(this.data1, other.data1);
                if (c != 0) {
                    return c;
                }
                c = Integer.compare(this.data2, other.data2);
                if (c != 0) {
                    return c;
                }
                c = Integer.compare(this.data3, other.data3);
                if (c != 0) {
                    return c;
                }
                c = Integer.compare(this.data4, other.data4);
                if (c != 0) {
                    return c;
                }
                return Integer.compare(this.data5, other.data5);
            }
            return -1;
        }

        public void fromBytes(ByteBuf buf) {
            this.type = Type.values()[buf.readByte()];
            this.data1 = buf.readInt();
            this.data2 = buf.readInt();
            this.data3 = buf.readInt();
            this.data4 = buf.readInt();
            this.data5 = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.type.ordinal());
            buf.writeInt(this.data1);
            buf.writeInt(this.data2);
            buf.writeInt(this.data3);
            buf.writeInt(this.data4);
            buf.writeInt(this.data5);
        }

        public static enum Type {
            BLOCK(0),
            ENTITY(1);

            private final byte b;

            private Type(byte b) {
                this.b = b;
            }

            public byte getByte() {
                return this.b;
            }

            public boolean isEntity() {
                return this == ENTITY;
            }

            public boolean isBlock() {
                return this == BLOCK;
            }
        }
    }

    public static abstract class Reference {
        public abstract ReferenceId getId();

        @Nonnull
        public abstract ITextComponent getName();

        @Nullable
        public abstract Location<Integer, BlockPos> currentPos();

        @Nonnull
        public abstract Class getReferencedClass();

        @Nullable
        public abstract ResourceLocation getResourceLocation();
    }
}

