/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.tracking;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.api.TiqualityException;
import com.github.terminatornl.tiquality.api.event.TiqualityEvent;
import com.github.terminatornl.tiquality.interfaces.TiqualityChunk;
import com.github.terminatornl.tiquality.interfaces.TiqualityEntity;
import com.github.terminatornl.tiquality.interfaces.TiqualitySimpleTickable;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.interfaces.UpdateTyped;
import com.github.terminatornl.tiquality.memory.WeakReferencedChunk;
import com.github.terminatornl.tiquality.memory.WeakReferencedTracker;
import com.github.terminatornl.tiquality.profiling.ProfilingKey;
import com.github.terminatornl.tiquality.profiling.TickLogger;
import com.github.terminatornl.tiquality.tracking.TrackerHolder;
import com.github.terminatornl.tiquality.tracking.UpdateType;
import com.github.terminatornl.tiquality.tracking.tickqueue.TickQueue;
import com.github.terminatornl.tiquality.tracking.update.BlockRandomUpdateHolder;
import com.github.terminatornl.tiquality.tracking.update.BlockUpdateHolder;
import com.github.terminatornl.tiquality.util.SynchronizedAction;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TrackerBase
implements Tracker {
    protected final HashSet<WeakReferencedChunk> ASSOCIATED_CHUNKS = new HashSet();
    protected final HashSet<WeakReferencedTracker> DELEGATING_TRACKERS = new HashSet();
    public TickQueue tickQueue = new TickQueue(this);
    protected boolean isUnloaded = false;
    protected long tick_time_remaining_ns = 50000000L;
    protected TickLogger tickLogger = new TickLogger();
    private TrackerHolder holder;
    @Nullable
    private ProfilingKey key;
    private int unloadCooldown = 40;
    private boolean isProfiling = false;

    @Override
    public TrackerHolder getHolder() {
        return this.holder;
    }

    @Override
    public void setHolder(TrackerHolder holder) {
        if (this.holder != null) {
            throw new IllegalStateException("Attempt to bind two holders to one tracker.");
        }
        this.holder = holder;
    }

    @Override
    public boolean shouldSaveToDisk() {
        return true;
    }

    @Override
    public void tick() {
        this.tickQueue.notifyNextTick();
    }

    @Override
    public boolean canProfile() {
        return true;
    }

    @Override
    public boolean isProfiling() {
        return this.isProfiling;
    }

    @Override
    public long getProfileEndTime() {
        return this.key == null ? 0L : this.key.getProfileEndTime();
    }

    @Override
    @Nonnull
    public ProfilingKey startProfiler(long profileEndTime) throws TiqualityException.TrackerAlreadyProfilingException {
        if (this.isProfiling) {
            throw new TiqualityException.TrackerAlreadyProfilingException(this);
        }
        this.key = new ProfilingKey(profileEndTime);
        Tiquality.SCHEDULER.schedule(new Runnable(){

            @Override
            public void run() {
                TrackerBase.this.isProfiling = true;
            }
        });
        return this.key;
    }

    @Override
    @Nonnull
    public TickLogger stopProfiler(ProfilingKey key) throws TiqualityException.InvalidKeyException {
        if (this.key != key) {
            throw new TiqualityException.InvalidKeyException(this, this.key);
        }
        return SynchronizedAction.run(new SynchronizedAction.Action<TickLogger>(){

            @Override
            public void run(SynchronizedAction.DynamicVar<TickLogger> variable) {
                if (TrackerBase.this.isProfiling) {
                    TrackerBase.this.isProfiling = false;
                    TrackerBase.this.key = null;
                    MinecraftForge.EVENT_BUS.post((Event)new TiqualityEvent.ProfileCompletedEvent(TrackerBase.this, TrackerBase.this.tickLogger));
                    variable.set(TrackerBase.this.tickLogger);
                    TrackerBase.this.tickLogger = new TickLogger();
                }
            }
        });
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setNextTickTime(long granted_ns) {
        this.tick_time_remaining_ns = granted_ns;
        if (this.isProfiling) {
            this.tickLogger.addServerTick(granted_ns);
        }
        if (this.unloadCooldown > 0) {
            --this.unloadCooldown;
        }
    }

    @Override
    public void consume(long time) {
        this.tick_time_remaining_ns -= time;
    }

    @Override
    public long getRemainingTime() {
        return this.tick_time_remaining_ns;
    }

    public boolean updateOld() {
        while (this.tickQueue.size() > 0 && this.getRemainingTime() > 0L) {
            long start;
            TiqualitySimpleTickable tickable = this.tickQueue.take();
            if (!tickable.tiquality_isLoaded()) continue;
            if (this.isProfiling) {
                start = System.nanoTime();
                tickable.tiquality_doUpdateTick();
                long elapsed = System.nanoTime() - start;
                this.tickLogger.addNanosAndIncrementCalls(tickable.getId(), elapsed);
                this.consume(elapsed);
                continue;
            }
            start = System.nanoTime();
            tickable.tiquality_doUpdateTick();
            this.consume(System.nanoTime() - start);
        }
        return this.getRemainingTime() > 0L;
    }

    @Override
    public void addTickableToQueue(TiqualitySimpleTickable tickable) {
        if (this.tickQueue.containsSimpleUpdate(tickable)) {
            this.tickQueue.addToQueue(tickable);
        }
    }

    @Override
    public void tickSimpleTickable(TiqualitySimpleTickable tileEntity) {
        if (!this.updateOld() && !tileEntity.getUpdateType().mustTick(this)) {
            if (!this.tickQueue.containsTileEntityUpdate(tileEntity)) {
                this.tickQueue.addToQueue(tileEntity);
            }
        } else if (this.isProfiling) {
            long start = System.nanoTime();
            tileEntity.tiquality_doUpdateTick();
            long elapsed = System.nanoTime() - start;
            this.tickLogger.addNanosAndIncrementCalls(tileEntity.getId(), elapsed);
            this.consume(elapsed);
        } else {
            long start = System.nanoTime();
            tileEntity.tiquality_doUpdateTick();
            this.consume(System.nanoTime() - start);
        }
    }

    @Override
    public void tickEntity(TiqualityEntity entity) {
        if (this.isUnloaded) {
            entity.tiquality_doUpdateTick();
            entity.setTrackerHolder(null);
            return;
        }
        if (!this.updateOld() && !entity.getUpdateType().mustTick(this)) {
            if (!this.tickQueue.containsEntityUpdate(entity)) {
                this.tickQueue.addToQueue(entity);
            }
        } else if (this.isProfiling) {
            long start = System.nanoTime();
            entity.tiquality_doUpdateTick();
            long elapsed = System.nanoTime() - start;
            this.tickLogger.addNanosAndIncrementCalls(entity.getId(), elapsed);
            this.consume(elapsed);
        } else {
            long start = System.nanoTime();
            entity.tiquality_doUpdateTick();
            this.consume(System.nanoTime() - start);
        }
    }

    @Override
    public void doBlockTick(Block block, World world, BlockPos pos, IBlockState state, Random rand) {
        UpdateType updateType = ((UpdateTyped)block).getUpdateType();
        if (!this.updateOld() && !updateType.mustTick(this)) {
            if (!this.tickQueue.containsBlockUpdate((TiqualityWorld)world, pos)) {
                this.tickQueue.addToQueue(new BlockUpdateHolder(world, pos, rand, updateType));
            }
        } else if (this.isProfiling) {
            long start = System.nanoTime();
            Tiquality.TICK_EXECUTOR.onBlockTick(block, world, pos, state, rand);
            long elapsed = System.nanoTime() - start;
            this.tickLogger.addNanosAndIncrementCalls(BlockUpdateHolder.getId(world.field_73011_w.getDimension(), pos), elapsed);
            this.consume(elapsed);
        } else {
            long start = System.nanoTime();
            Tiquality.TICK_EXECUTOR.onBlockTick(block, world, pos, state, rand);
            this.consume(System.nanoTime() - start);
        }
    }

    @Override
    public void doRandomBlockTick(Block block, World world, BlockPos pos, IBlockState state, Random rand) {
        UpdateType updateType = ((UpdateTyped)block).getUpdateType();
        if (!this.updateOld() && !updateType.mustTick(this)) {
            if (!this.tickQueue.containsRandomBlockUpdate((TiqualityWorld)world, pos)) {
                this.tickQueue.addToQueue(new BlockRandomUpdateHolder(world, pos, rand, updateType));
            }
        } else if (this.isProfiling) {
            long start = System.nanoTime();
            Tiquality.TICK_EXECUTOR.onRandomBlockTick(block, world, pos, state, rand);
            long elapsed = System.nanoTime() - start;
            this.tickLogger.addNanosAndIncrementCalls(BlockRandomUpdateHolder.getId(world.field_73011_w.getDimension(), pos), elapsed);
            this.consume(elapsed);
        } else {
            long start = System.nanoTime();
            Tiquality.TICK_EXECUTOR.onRandomBlockTick(block, world, pos, state, rand);
            this.consume(System.nanoTime() - start);
        }
    }

    @Override
    public void grantTick() {
        if (this.tickQueue.size() > 0) {
            TiqualitySimpleTickable tickable = this.tickQueue.take();
            if (!tickable.tiquality_isLoaded()) {
                return;
            }
            if (this.isProfiling) {
                long start = System.nanoTime();
                tickable.tiquality_doUpdateTick();
                long elapsed = System.nanoTime() - start;
                this.tickLogger.addNanosAndIncrementCalls(tickable.getId(), elapsed);
            } else {
                tickable.tiquality_doUpdateTick();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void associateChunk(TiqualityChunk chunk) {
        this.unloadCooldown = 40;
        HashSet<WeakReferencedChunk> hashSet = this.ASSOCIATED_CHUNKS;
        synchronized (hashSet) {
            this.ASSOCIATED_CHUNKS.add(new WeakReferencedChunk(chunk));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void associateDelegatingTracker(Tracker tracker) {
        this.unloadCooldown = 40;
        HashSet<WeakReferencedTracker> hashSet = this.DELEGATING_TRACKERS;
        synchronized (hashSet) {
            this.DELEGATING_TRACKERS.add(new WeakReferencedTracker(tracker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDelegatingTracker(Tracker tracker) {
        HashSet<WeakReferencedTracker> hashSet = this.DELEGATING_TRACKERS;
        synchronized (hashSet) {
            this.DELEGATING_TRACKERS.removeIf(t -> tracker.equals(t.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLoaded() {
        if (this.isUnloaded) {
            return false;
        }
        HashSet<WeakReference> hashSet = this.ASSOCIATED_CHUNKS;
        synchronized (hashSet) {
            this.ASSOCIATED_CHUNKS.removeIf(chunk -> !chunk.isChunkLoaded());
            if (this.ASSOCIATED_CHUNKS.size() > 0) {
                return true;
            }
        }
        hashSet = this.DELEGATING_TRACKERS;
        synchronized (hashSet) {
            this.DELEGATING_TRACKERS.removeIf(tracker -> !tracker.exists());
            if (this.DELEGATING_TRACKERS.size() > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getClass() + ":{nsleft: " + this.getRemainingTime() + ", unticked: " + this.tickQueue.size() + ", hashCode: " + System.identityHashCode(this) + "}";
    }

    @Override
    public boolean shouldUnload() {
        return !this.isLoaded() && this.unloadCooldown == 0 && !this.isProfiling;
    }

    @Override
    public boolean needsTick() {
        return this.tickQueue.size() > 0;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void onUnload() {
        this.isUnloaded = true;
        this.tickQueue.tickAll();
    }

    @Override
    @Nonnull
    public TickLogger getTickLogger() throws TiqualityException.TrackerWasNotProfilingException {
        if (!this.isProfiling) {
            throw new TiqualityException.TrackerWasNotProfilingException(this);
        }
        return this.tickLogger;
    }
}

