/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.tracking.tickqueue;

import com.github.terminatornl.tiquality.interfaces.TiqualitySimpleTickable;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.memory.WeakReferencedTracker;
import com.github.terminatornl.tiquality.tracking.UpdateType;
import com.github.terminatornl.tiquality.tracking.tickqueue.RelativeTPSTracker;
import java.util.LinkedList;
import net.minecraft.util.math.BlockPos;

public class TickQueue {
    public final WeakReferencedTracker tracker;
    public final RelativeTPSTracker relativeTPSTracker;
    private final LinkedList<TiqualitySimpleTickable> data = new LinkedList();

    public TickQueue(Tracker tracker) {
        this.tracker = new WeakReferencedTracker(tracker);
        this.relativeTPSTracker = new RelativeTPSTracker(this);
    }

    public void notifyNextTick() {
        this.relativeTPSTracker.notifyNextTick();
    }

    public boolean containsBlockUpdate(TiqualityWorld world, BlockPos pos) {
        return world.tiquality_isMarked(pos);
    }

    public boolean containsRandomBlockUpdate(TiqualityWorld world, BlockPos pos) {
        return world.tiquality_isMarked(pos);
    }

    public boolean containsTileEntityUpdate(TiqualitySimpleTickable tickable) {
        return tickable.tiquality_isMarked();
    }

    public boolean containsEntityUpdate(TiqualitySimpleTickable entity) {
        return entity.tiquality_isMarked();
    }

    public boolean containsSimpleUpdate(TiqualitySimpleTickable update) {
        return update.tiquality_isMarked();
    }

    public void addToQueue(TiqualitySimpleTickable tickable) {
        tickable.tiquality_mark();
        if (tickable.getUpdateType() == UpdateType.PRIORITY) {
            this.data.addFirst(tickable);
        } else {
            this.data.addLast(tickable);
        }
    }

    public TiqualitySimpleTickable take() {
        TiqualitySimpleTickable t = this.data.removeFirst();
        t.tiquality_unMark();
        return t;
    }

    public void tickAll() {
        while (this.data.size() > 0) {
            TiqualitySimpleTickable tickable = this.take();
            if (!tickable.tiquality_isLoaded()) continue;
            tickable.tiquality_doUpdateTick();
        }
    }

    public int size() {
        return this.data.size();
    }
}

