/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.tracking.update;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.interfaces.TiqualityChunk;
import com.github.terminatornl.tiquality.interfaces.TiqualitySimpleTickable;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.profiling.ReferencedTickable;
import com.github.terminatornl.tiquality.tracking.UpdateType;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockUpdateHolder
implements TiqualitySimpleTickable {
    private final World world;
    private final BlockPos pos;
    private final Random rand;
    private UpdateType updateType;

    public BlockUpdateHolder(World world, BlockPos pos, Random rand, UpdateType updateType) {
        this.world = world;
        this.pos = pos;
        this.rand = rand;
        this.updateType = updateType;
    }

    @Nonnull
    public static ReferencedTickable.BlockReference getId(int dim, BlockPos pos) {
        return new ReferencedTickable.BlockReference(dim, pos);
    }

    @Override
    public boolean tiquality_isLoaded() {
        return this.world.func_175667_e(this.pos);
    }

    @Override
    public void tiquality_doUpdateTick() {
        TiqualityChunk chunk = ((TiqualityWorld)this.world).getTiqualityChunk(this.pos);
        IBlockState state = chunk.getMinecraftChunk().func_177435_g(this.pos);
        Tiquality.TICK_EXECUTOR.onBlockTick(state.func_177230_c(), this.world, this.pos, state, this.rand);
    }

    @Override
    public BlockPos tiquality_getPos() {
        return this.pos;
    }

    @Override
    public World tiquality_getWorld() {
        return this.world;
    }

    @Override
    @Nullable
    public ReferencedTickable.Reference getId() {
        return new ReferencedTickable.BlockReference(this.world.field_73011_w.getDimension(), this.pos);
    }

    @Override
    public void tiquality_mark() {
        ((TiqualityWorld)this.world).tiquality_mark(this.pos);
    }

    @Override
    public void tiquality_unMark() {
        ((TiqualityWorld)this.world).tiquality_unMark(this.pos);
    }

    @Override
    public boolean tiquality_isMarked() {
        return ((TiqualityWorld)this.world).tiquality_isMarked(this.pos);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlockUpdateHolder)) {
            return false;
        }
        BlockUpdateHolder other = (BlockUpdateHolder)o;
        return other.pos.equals((Object)this.pos);
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    @Override
    @Nonnull
    public UpdateType getUpdateType() {
        return this.updateType;
    }

    @Override
    public void setUpdateType(@Nonnull UpdateType type) {
        this.updateType = type;
    }
}

