/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.text.NucleusTextTemplate;
import io.github.nucleuspowered.nucleus.services.impl.texttemplatefactory.NucleusTextTemplateImpl;
import io.github.nucleuspowered.nucleus.services.interfaces.INucleusTextTemplateFactory;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public final class TextFileController {
    private static final Text padding = Text.of((Object[])new Object[]{TextColors.GOLD, "-"});
    private static final List<Charset> characterSetsToTest = Lists.newArrayList((Object[])new Charset[]{StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1, StandardCharsets.US_ASCII, StandardCharsets.UTF_16});
    @Nullable
    private final Asset asset;
    private final Path fileLocation;
    private final List<String> fileContents = Lists.newArrayList();
    private final List<NucleusTextTemplateImpl> textTemplates = Lists.newArrayList();
    private final boolean getTitle;
    private final INucleusTextTemplateFactory textTemplateFactory;
    private long fileTimeStamp = 0L;
    @Nullable
    private NucleusTextTemplate title;

    public TextFileController(INucleusTextTemplateFactory textTemplateFactory, Path fileLocation, boolean getTitle) throws IOException {
        this(textTemplateFactory, null, fileLocation, getTitle);
    }

    public TextFileController(INucleusTextTemplateFactory textTemplateFactory, @Nullable Asset asset, Path fileLocation) throws IOException {
        this(textTemplateFactory, asset, fileLocation, false);
    }

    private TextFileController(INucleusTextTemplateFactory textTemplateFactory, @Nullable Asset asset, Path fileLocation, boolean getTitle) throws IOException {
        this.textTemplateFactory = textTemplateFactory;
        this.asset = asset;
        this.fileLocation = fileLocation;
        this.getTitle = getTitle;
        this.load();
    }

    public void load() throws IOException {
        if (this.asset != null && !Files.exists(this.fileLocation, new LinkOption[0])) {
            this.asset.copyToFile(this.fileLocation);
        }
        ArrayList fileContents = Lists.newArrayList();
        MalformedInputException exception = null;
        for (Charset charset : characterSetsToTest) {
            try {
                fileContents.addAll(Files.readAllLines(this.fileLocation, charset));
                exception = null;
                break;
            }
            catch (MalformedInputException ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
        this.fileTimeStamp = Files.getLastModifiedTime(this.fileLocation, new LinkOption[0]).toMillis();
        this.fileContents.clear();
        this.fileContents.addAll(fileContents);
        this.textTemplates.clear();
    }

    public Optional<Text> getTitle(CommandSource source) {
        if (this.getTitle && this.textTemplates.isEmpty() && !this.fileContents.isEmpty()) {
            this.getFileContentsAsText();
        }
        if (this.title != null) {
            return Optional.of(this.title.getForCommandSource(source));
        }
        return Optional.empty();
    }

    public List<Text> getTextFromNucleusTextTemplates(CommandSource source) {
        return this.getFileContentsAsText().stream().map(x -> x.getForCommandSource(source)).collect(Collectors.toList());
    }

    public void sendToPlayer(CommandSource src, Text title) {
        PaginationList.Builder pb = Util.getPaginationBuilder(src).contents(this.getTextFromNucleusTextTemplates(src));
        if (title != null && !title.isEmpty()) {
            pb.title(title).padding(padding);
        } else {
            pb.padding(Util.SPACE);
        }
        pb.sendTo((MessageReceiver)src);
    }

    private ImmutableList<NucleusTextTemplateImpl> getFileContentsAsText() {
        this.checkFileStamp();
        if (this.textTemplates.isEmpty()) {
            ArrayList contents = Lists.newArrayList(this.fileContents);
            if (this.getTitle) {
                this.title = this.getTitleFromStrings(contents);
                if (this.title != null) {
                    String n;
                    contents.remove(0);
                    Iterator i = contents.iterator();
                    while (i.hasNext() && ((n = (String)i.next()).isEmpty() || n.matches("^\\s+$"))) {
                        i.remove();
                    }
                }
            }
            contents.forEach(x -> this.textTemplates.add(this.textTemplateFactory.createFromAmpersandString((String)x)));
        }
        return ImmutableList.copyOf(this.textTemplates);
    }

    @Nullable
    private NucleusTextTemplate getTitleFromStrings(List<String> info) {
        String sec1;
        if (!info.isEmpty() && (sec1 = info.get(0)).startsWith("#")) {
            if ((sec1 = sec1.replaceFirst("#\\s*", "")).length() > 50) {
                sec1 = sec1.substring(0, 50);
            }
            return this.textTemplateFactory.createFromAmpersandString(sec1);
        }
        return null;
    }

    private void checkFileStamp() {
        try {
            if (this.fileContents.isEmpty() || Files.getLastModifiedTime(this.fileLocation, new LinkOption[0]).toMillis() > this.fileTimeStamp) {
                this.load();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

