/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.home.commands;

import io.github.nucleuspowered.nucleus.api.module.home.NucleusHomeService;
import io.github.nucleuspowered.nucleus.api.module.home.data.Home;
import io.github.nucleuspowered.nucleus.api.module.home.exception.HomeException;
import io.github.nucleuspowered.nucleus.modules.home.commands.HomeCommand;
import io.github.nucleuspowered.nucleus.modules.home.config.HomeConfig;
import io.github.nucleuspowered.nucleus.modules.home.services.HomeService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@EssentialsEquivalent(value={"sethome", "createhome"})
@NonnullByDefault
@Command(aliases={"set", "#homeset", "#sethome"}, basePermission={"nucleus.home.set.base"}, commandDescriptionKey="home.set", parentCommand=HomeCommand.class, modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.home.set.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.home.set.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.home.set.exempt.cost")}, associatedPermissions={"nucleus.home.set.unlimited"}, associatedOptions={"home-count"})
public class SetHomeCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private final String homeKey = "home";
    private boolean preventOverhang = true;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"o", "-overwrite"}).buildWith(GenericArguments.onlyOne((CommandElement)GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"home")))))};
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.preventOverhang = serviceCollection.moduleDataProvider().getModuleConfig(HomeConfig.class).isPreventHomeCountOverhang();
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        boolean overwrite;
        String home = context.getOne(this.homeKey, String.class).orElse("home").toLowerCase();
        if (!NucleusHomeService.HOME_NAME_PATTERN.matcher(home).matches()) {
            return context.errorResult("command.sethome.name", new Object[0]);
        }
        Player src = context.getIfPlayer();
        HomeService homeService = context.getServiceCollection().getServiceUnchecked(HomeService.class);
        Optional<Home> currentHome = homeService.getHome((User)src, home);
        boolean bl = overwrite = currentHome.isPresent() && context.hasAny("o");
        if (currentHome.isPresent() && !overwrite) {
            context.sendMessage("command.sethome.seterror", home);
            context.sendMessageText(context.getMessage("command.sethome.tooverwrite", home).toBuilder().onClick((ClickAction)TextActions.runCommand((String)("/sethome " + home + " -o"))).build());
            return context.failResult();
        }
        try {
            if (overwrite) {
                int max = homeService.getMaximumHomes((User)src);
                int c = homeService.getHomeCount((User)src);
                if (this.preventOverhang && max < c) {
                    context.errorResult("command.sethome.overhang", max, c);
                }
                Home current = currentHome.get();
                homeService.modifyHomeInternal(context.getCause(), current, (Location<World>)src.getLocation(), src.getRotation());
                context.sendMessage("command.sethome.overwrite", home);
            } else {
                homeService.createHomeInternal(context.getCause(), (User)src, home, (Location<World>)src.getLocation(), src.getRotation());
            }
        }
        catch (HomeException e) {
            return context.errorResultLiteral(e.getText());
        }
        context.sendMessage("command.sethome.set", home);
        return context.successResult();
    }
}

