/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.nameban.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.api.module.nameban.exception.NameBanException;
import io.github.nucleuspowered.nucleus.modules.nameban.config.NameBanConfig;
import io.github.nucleuspowered.nucleus.modules.nameban.services.NameBanHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.RegexArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"nameban"}, basePermission={"nucleus.nameban.base"}, commandDescriptionKey="nameban")
public class NameBanCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private final String nameKey = "name";
    private String defaultReason = "Your name is inappropriate";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{new RegexArgument((Text)Text.of((String)this.nameKey), "[0-9a-zA-Z_]{3,16}", "command.nameban.notvalid", (commandSource, commandArgs, commandContext) -> {
            try {
                String arg = commandArgs.peek().toLowerCase();
                return Sponge.getServer().getOnlinePlayers().stream().map(User::getName).filter(name -> name.toLowerCase().startsWith(arg)).collect(Collectors.toList());
            }
            catch (Exception e) {
                return Lists.newArrayList();
            }
        }, serviceCollection), NucleusParameters.OPTIONAL_REASON};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        String name = context.requireOne(this.nameKey, String.class).toLowerCase();
        String reason = context.getOne("reason", String.class).orElse(this.defaultReason);
        NameBanHandler handler = context.getServiceCollection().getServiceUnchecked(NameBanHandler.class);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause((Object)context.getCommandSource());
            handler.addName(name, reason, frame.getCurrentCause());
            context.sendMessage("command.nameban.success", name);
            ICommandResult iCommandResult = context.successResult();
            return iCommandResult;
        }
        catch (NameBanException ex) {
            ex.printStackTrace();
            return context.errorResult("command.nameban.failed", name);
        }
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.defaultReason = serviceCollection.moduleDataProvider().getModuleConfig(NameBanConfig.class).getDefaultReason();
    }
}

