/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.rules.commands;

import io.github.nucleuspowered.nucleus.modules.rules.config.RulesConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@EssentialsEquivalent(value={"rules"})
@Command(aliases={"rules"}, basePermission={"nucleus.rules.base"}, commandDescriptionKey="rules", async=true)
public class RulesCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private Text title = Text.EMPTY;

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        context.getServiceCollection().textFileControllerCollection().get("rules").orElseThrow(() -> context.createException("command.rules.empty", new Object[0])).sendToPlayer(context.getCommandSource(), this.title);
        return context.successResult();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        RulesConfig config = serviceCollection.moduleDataProvider().getModuleConfig(RulesConfig.class);
        String title = config.getRulesTitle();
        this.title = title.isEmpty() ? Text.EMPTY : TextSerializers.FORMATTING_CODE.deserialize(title);
    }
}

