/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.teleport.commands;

import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportResult;
import io.github.nucleuspowered.nucleus.modules.teleport.config.TeleportConfig;
import io.github.nucleuspowered.nucleus.modules.teleport.services.PlayerTeleporterService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.IfConditionElseArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@EssentialsEquivalent(value={"tphere", "s", "tpohere"}, isExact=false, notes="If you have permission, this will override '/tptoggle' automatically.")
@NonnullByDefault
@Command(aliases={"tphere", "tph"}, basePermission={"nucleus.teleport.tphere.base"}, commandDescriptionKey="tphere", associatedPermissions={"nucleus.teleport.tphere.offline", "nucleus.teleport.tptoggle.exempt"})
public class TeleportHereCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private boolean isDefaultQuiet = false;

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.isDefaultQuiet = serviceCollection.moduleDataProvider().getModuleConfig(TeleportConfig.class).isDefaultQuiet();
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"q", "-quiet"}).buildWith((CommandElement)IfConditionElseArgument.permission(serviceCollection.permissionService(), "nucleus.teleport.tphere.offline", NucleusParameters.ONE_USER_PLAYER_KEY.get(serviceCollection), NucleusParameters.ONE_PLAYER.get(serviceCollection)))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        boolean beQuiet = context.getOne("q", Boolean.class).orElse(this.isDefaultQuiet);
        User target = context.requireOne("player", User.class);
        PlayerTeleporterService sts = context.getServiceCollection().getServiceUnchecked(PlayerTeleporterService.class);
        if (target.getPlayer().isPresent()) {
            Player to = (Player)target.getPlayer().get();
            TeleportResult result = sts.teleportWithMessage((CommandSource)context.getIfPlayer(), to, context.getIfPlayer(), false, false, beQuiet);
            return result.isSuccessful() ? context.successResult() : context.failResult();
        }
        if (!context.testPermission("nucleus.teleport.tphere.offline")) {
            return context.errorResult("command.tphere.noofflineperms", new Object[0]);
        }
        Player src = context.getIfPlayer();
        target.setLocation(src.getPosition(), src.getWorld().getUniqueId());
        context.sendMessage("command.tphere.offlinesuccess", target.getName());
        return context.successResult();
    }
}

