/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.vanish.infoprovider;

import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.playerinformation.NucleusProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;

public class VanishInfoProvider
implements NucleusProvider.Permission {
    private final INucleusServiceCollection serviceCollection;

    @Inject
    public VanishInfoProvider(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
    }

    @Override
    public String getCategory() {
        return "vanish";
    }

    @Override
    public String permission() {
        return "nucleus.vanish.see";
    }

    @Override
    @Nullable
    public Text getText(User user, CommandSource source, INucleusServiceCollection serviceCollection) {
        IMessageProviderService providerService = this.serviceCollection.messageProvider();
        String isVanished = Boolean.toString(user.get(Keys.VANISH).orElse(false));
        String yesNo = providerService.getMessageString("standard.yesno." + isVanished.toLowerCase(), new Object[0]);
        return providerService.getMessageFor(source, "seen.vanish", yesNo);
    }
}

